/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import cdc.issues.api.IssuesFactoryFeatures;
import cdc.issues.api.io.IssuesFormat;
import cdc.issues.api.io.IssuesReader;
import cdc.issues.api.io.IssuesWriter;
import cdc.util.lang.Checks;
import cdc.util.lang.FailureReaction;
import cdc.util.lang.Introspection;
import java.io.File;

public class IssuesFactory {
    private final IssuesFactoryFeatures features;

    public IssuesFactory(IssuesFactoryFeatures features) {
        this.features = features;
    }

    public IssuesFactoryFeatures getFeatures() {
        return this.features;
    }

    public boolean canExportTo(File file) {
        if (file == null) {
            return false;
        }
        IssuesFormat format = IssuesFormat.from(file);
        return format != null && format.isExportFormat();
    }

    public IssuesWriter createIssuesWriter(File file) {
        Checks.isNotNull((Object)file, (String)"file");
        IssuesFormat format = IssuesFormat.from(file);
        if (format != null) {
            switch (format) {
                case CSV: 
                case ODS: 
                case XLS: 
                case XLSM: 
                case XLSX: {
                    return this.createIssuesWriter("cdc.issues.core.WorkbookIssuesWriter");
                }
                case JSON: {
                    return this.createIssuesWriter("cdc.issues.core.JsonIssuesWriter");
                }
                case XML: {
                    return this.createIssuesWriter("cdc.issues.core.XmlIssuesWriter");
                }
            }
        }
        throw new IllegalArgumentException("Can not create an IssuesWriter for " + file);
    }

    private IssuesWriter createIssuesWriter(String className) {
        Class cls = Introspection.uncheckedCast((Class)Introspection.getClass((String)className, IssuesWriter.class, (FailureReaction)FailureReaction.FAIL));
        Class[] parameterTypes = new Class[]{IssuesFactoryFeatures.class};
        return (IssuesWriter)Introspection.newInstance((Class)cls, (Class[])parameterTypes, (FailureReaction)FailureReaction.FAIL, (Object[])new Object[]{this.getFeatures()});
    }

    public boolean canImportFrom(File file) {
        if (file == null) {
            return false;
        }
        IssuesFormat format = IssuesFormat.from(file);
        return format != null && format.isImportFormat();
    }

    public IssuesReader createIssuesReader(File file) {
        Checks.isNotNull((Object)file, (String)"file");
        IssuesFormat format = IssuesFormat.from(file);
        if (format != null) {
            switch (format) {
                case CSV: 
                case ODS: 
                case XLS: 
                case XLSM: 
                case XLSX: {
                    return this.createIssuesReader("cdc.issues.core.WorkbookIssuesReader");
                }
                case JSON: {
                    return this.createIssuesReader("cdc.issues.core.JsonIssuesReader");
                }
                case XML: {
                    return this.createIssuesReader("cdc.issues.core.XmlIssuesReader");
                }
            }
        }
        throw new IllegalArgumentException("Can not create an IssuesReader for " + file);
    }

    private IssuesReader createIssuesReader(String className) {
        Class cls = Introspection.uncheckedCast((Class)Introspection.getClass((String)className, IssuesReader.class, (FailureReaction)FailureReaction.FAIL));
        Class[] parameterTypes = new Class[]{IssuesFactoryFeatures.class};
        return (IssuesReader)Introspection.newInstance((Class)cls, (Class[])parameterTypes, (FailureReaction)FailureReaction.FAIL, (Object[])new Object[]{this.getFeatures()});
    }
}

