/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api.locations;

import cdc.issues.api.locations.AbstractLocation;
import cdc.util.lang.Checks;

public class WorkbookLocation
extends AbstractLocation {
    private final String systemId;
    private final String sheetName;
    private final int rowNumber;
    private final String columnName;

    private WorkbookLocation(String systemId, String sheetName, int rowNumber, String columnName) {
        this.systemId = (String)Checks.isNotNull((Object)systemId, (String)"systemId");
        this.sheetName = sheetName;
        this.rowNumber = rowNumber;
        this.columnName = columnName;
        if ((rowNumber > 0 || columnName != null) && sheetName == null) {
            throw new IllegalArgumentException("Sheet name is missing.");
        }
    }

    @Override
    public String getPath() {
        return this.getSystemId();
    }

    @Override
    public String getAnchor() {
        if (this.sheetName == null) {
            return "";
        }
        if (this.columnName == null) {
            if (this.rowNumber <= 0) {
                return this.sheetName;
            }
            return this.sheetName + "[:" + this.rowNumber + "]";
        }
        if (this.rowNumber <= 0) {
            return this.sheetName + "[" + this.columnName + "]";
        }
        return this.sheetName + "[" + this.columnName + ":" + this.rowNumber + "]";
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isColumnLocation() {
        return this.rowNumber <= 0 && this.columnName != null;
    }

    public boolean isRowLocation() {
        return this.rowNumber > 0 && this.columnName == null;
    }

    public boolean isCellLocation() {
        return this.rowNumber > 0 && this.columnName != null;
    }

    public boolean isSheetLocation() {
        return this.sheetName != null && this.rowNumber <= 0 && this.columnName == null;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String systemId;
        private String sheetName = null;
        private int rowNumber = 0;
        private String columnName = null;

        private Builder() {
        }

        public Builder systemId(String systemId) {
            this.systemId = systemId;
            return this;
        }

        public Builder sheetName(String sheetName) {
            this.sheetName = sheetName;
            return this;
        }

        public Builder rowNumber(int rowNumber) {
            this.rowNumber = rowNumber;
            return this;
        }

        public Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public WorkbookLocation build() {
            return new WorkbookLocation(this.systemId, this.sheetName, this.rowNumber, this.columnName);
        }
    }
}

