/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api.rules;

import cdc.issues.api.Params;
import cdc.issues.api.rules.IssuesDetector;
import cdc.issues.api.rules.Rule;
import cdc.util.lang.Checks;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractIssueDetector<T>
implements IssuesDetector<T> {
    protected final IssuesDetector.Descriptor<T> descriptor;
    protected final Params params;
    protected final Set<Rule> enabledRules;

    protected AbstractIssueDetector(IssuesDetector.Descriptor<T> descriptor, Params params, Set<Rule> rules) {
        this.descriptor = (IssuesDetector.Descriptor)Checks.isNotNull(descriptor, (String)"descriptor");
        this.params = (Params)Checks.isNotNull((Object)params, (String)"params");
        this.enabledRules = Collections.unmodifiableSet(new HashSet<Rule>(rules));
        if (!descriptor.getRules().containsAll(this.enabledRules)) {
            throw new IllegalArgumentException("Non supported rules");
        }
    }

    protected AbstractIssueDetector(IssuesDetector.Descriptor<T> descriptor, Set<Rule> rules) {
        this(descriptor, Params.NO_PARAMS, rules);
    }

    @Override
    public IssuesDetector.Descriptor<T> getDescriptor() {
        return this.descriptor;
    }

    @Override
    public final Set<Rule> getEnabledRules() {
        return this.enabledRules;
    }

    @Override
    public final Params getParams() {
        return this.params;
    }

    public String toString() {
        return IssuesDetector.toString(this);
    }
}

