/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api.rules;

import cdc.issues.api.Issue;
import cdc.issues.api.IssuesHandler;
import cdc.issues.api.Params;
import cdc.issues.api.locations.LocatedData;
import cdc.issues.api.rules.IssuesDetector;
import cdc.issues.api.rules.Rule;
import cdc.util.events.ProgressController;
import cdc.util.events.ProgressSupplier;
import cdc.util.lang.Checks;
import cdc.util.lang.NotFoundException;
import java.util.HashSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public interface RulesCatalog {
    public Set<String> getDomains();

    default public boolean hasDomain(String domain) {
        return this.getDomains().contains(domain);
    }

    public Set<Rule> getRules();

    default public boolean hasRule(Rule rule) {
        return this.getRules().contains(rule);
    }

    default public Set<Rule> getRules(String domain) {
        return this.getRules().stream().filter(rule -> rule.getDomain().equals(domain)).collect(Collectors.toSet());
    }

    public Set<IssuesDetector.Descriptor<?>> getDescriptors();

    public <T> Set<IssuesDetector.Descriptor<T>> getDescriptors(Class<T> var1);

    public <T> IssuesDetector.Descriptor<T> getDescriptorOrNull(Rule var1, Class<T> var2);

    default public <T> IssuesDetector.Descriptor<T> getDescriptor(Rule rule, Class<T> dataClass) {
        IssuesDetector.Descriptor<T> descriptor = this.getDescriptorOrNull(rule, dataClass);
        if (descriptor == null) {
            throw new NotFoundException("No descriptor found for [" + rule.getName() + ", " + dataClass.getCanonicalName() + "]");
        }
        return descriptor;
    }

    default public boolean hasDescriptor(Rule rule, Class<?> dataClass) {
        return this.getDescriptorOrNull(rule, dataClass) != null;
    }

    default public <T> IssuesDetector<T> createIssuesDetector(Rule rule, Class<T> dataClass, Params params) {
        IssuesDetector.Descriptor<T> descriptor = this.getDescriptor(rule, dataClass);
        HashSet<Rule> rules = new HashSet<Rule>();
        rules.add(rule);
        return descriptor.create(params, rules);
    }

    default public <T> IssuesDetector<T> createIssuesDetector(Rule rule, Class<T> dataClass) {
        return this.createIssuesDetector(rule, dataClass, Params.NO_PARAMS);
    }

    default public <T> void apply(Rule rule, Class<T> dataClass, Params params, Spliterator<LocatedData<T>> spliterator, IssuesHandler<Issue> issuesHandler, ProgressController controller) {
        IssuesDetector<T> detector = this.createIssuesDetector(rule, dataClass, params);
        RulesCatalog.apply(detector, spliterator, issuesHandler, controller);
    }

    default public <T> void apply(Class<T> dataClass, Params params, Spliterator<LocatedData<T>> spliterator, IssuesHandler<Issue> issuesHandler, ProgressController controller) {
        for (IssuesDetector.Descriptor<T> descriptor : this.getDescriptors(dataClass)) {
            IssuesDetector<T> detector = descriptor.create(params, descriptor.getRules());
            RulesCatalog.apply(detector, spliterator, issuesHandler, controller);
        }
    }

    public static <T> void apply(IssuesDetector<T> detector, Spliterator<LocatedData<T>> spliterator, IssuesHandler<Issue> issuesHandler, ProgressController controller) {
        Checks.isNotNull(detector, (String)"detector");
        Checks.isNotNull(spliterator, (String)"spliterator");
        Checks.isNotNull(issuesHandler, (String)"issuesHandler");
        Checks.isNotNull((Object)controller, (String)"controller");
        ProgressSupplier progress = new ProgressSupplier(controller);
        progress.reset(spliterator.estimateSize(), IssuesDetector.toString(detector));
        Consumer<LocatedData> consumer = ld -> detector.analyze(ld.getData(), ld.getLocation(), issuesHandler);
        boolean next = true;
        while (next) {
            next = next && spliterator.tryAdvance(consumer);
            next = next && !controller.isCancelled();
            progress.incrementValue();
        }
    }
}

