/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.Issue;
import cdc.issues.IssueSeverity;
import cdc.issues.IssueUtils;
import cdc.issues.IssuesCountingHandler;
import cdc.issues.IssuesHandler;
import cdc.util.lang.Checks;
import java.util.ArrayList;
import java.util.List;

public class IssuesCollector
implements IssuesCountingHandler {
    private final List<Issue> issues = new ArrayList<Issue>();
    private String hash;
    @Deprecated(since="2025-03-21", forRemoval=true)
    private final IssuesHandler delegate;

    @Deprecated(since="2025-03-21", forRemoval=true)
    public IssuesCollector(IssuesHandler delegate) {
        this.delegate = (IssuesHandler)Checks.isNotNull((Object)delegate, (String)"delegate");
    }

    public IssuesCollector() {
        this(IssuesHandler.VOID);
    }

    @Deprecated(since="2025-03-21", forRemoval=true)
    public IssuesHandler getDelegate() {
        return this.delegate;
    }

    public void clear() {
        this.hash = null;
        this.issues.clear();
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public List<Issue> getIssues(IssueSeverity severity) {
        return this.issues.stream().filter(i -> i.getSeverity() == severity).toList();
    }

    @Override
    public void issue(Issue issue) {
        this.hash = null;
        this.issues.add(issue);
        this.delegate.issue(issue);
    }

    @Override
    public int getNumberOfIssues() {
        return this.issues.size();
    }

    @Override
    public String getIssuesHash() {
        if (this.hash == null) {
            this.hash = IssueUtils.getHash(this.issues);
        }
        return this.hash;
    }
}

