/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.Issue;
import cdc.issues.IssueUtils;
import cdc.issues.Labels;
import cdc.issues.LabelsBuilding;
import cdc.issues.LabelsItem;
import cdc.issues.Metas;
import cdc.issues.MetasBuilding;
import cdc.issues.MetasItem;
import cdc.issues.Project;
import cdc.issues.SnapshotImpl;
import cdc.util.lang.Checks;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public interface Snapshot
extends MetasItem,
LabelsItem {
    public Optional<Project> getProject();

    public Instant getTimestamp();

    public String getName();

    public String getDescription();

    public List<Issue> getIssues();

    default public String getIssuesHash() {
        return IssueUtils.getHash(this.getIssues());
    }

    public static Builder builder(Project project) {
        return new Builder(project);
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public static class Builder
    implements MetasBuilding<Builder>,
    LabelsBuilding<Builder> {
        final Project project;
        String name;
        String description;
        final Metas.Builder metas = Metas.builder();
        Labels labels = Labels.NO_LABELS;
        Instant timestamp = Instant.now();
        final List<Issue> issues = new ArrayList<Issue>();

        Builder(Project project) {
            this.project = project;
        }

        public Builder name(String name) {
            this.name = name;
            return (Builder)this.self();
        }

        public Builder description(String description) {
            this.description = description;
            return (Builder)this.self();
        }

        @Override
        public Builder meta(String name, String value) {
            this.metas.meta(name, value);
            return (Builder)this.self();
        }

        @Override
        public Builder meta(String name, String value, String separator) {
            this.metas.meta(name, value, separator);
            return (Builder)this.self();
        }

        @Override
        public Builder metas(Metas metas) {
            this.metas.metas(metas);
            return (Builder)this.self();
        }

        @Override
        public Builder labels(Labels labels) {
            this.labels = labels;
            return (Builder)this.self();
        }

        public Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return (Builder)this.self();
        }

        public Builder issue(Issue issue) {
            this.issues.add((Issue)Checks.isNotNull((Object)issue, (String)"issue"));
            return (Builder)this.self();
        }

        public Builder issues(List<Issue> issues) {
            this.issues.addAll(issues);
            return (Builder)this.self();
        }

        public Snapshot build() {
            return new SnapshotImpl(this);
        }
    }
}

