/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.answers;

import cdc.issues.Issue;
import cdc.issues.IssueId;
import cdc.issues.answers.IssueAnswer;
import cdc.issues.answers.IssuesAndAnswerImpl;
import cdc.util.lang.Checks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface IssuesAndAnswers {
    public List<Issue> getIssues();

    public Set<? extends IssueAnswer> getAnswers();

    public Optional<IssueAnswer> getAnswer(IssueId var1);

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        final List<Issue> issues = new ArrayList<Issue>();
        final Set<IssueAnswer> answers = new HashSet<IssueAnswer>();
        final Map<IssueId, IssueAnswer> issueIdToAnswer = new HashMap<IssueId, IssueAnswer>();

        protected Builder self() {
            return this;
        }

        public Builder issue(Issue issue) {
            Checks.isNotNull((Object)issue, (String)"issue");
            this.issues.add(issue);
            return this.self();
        }

        public Builder issues(List<? extends Issue> issues) {
            this.issues.addAll(issues);
            return this.self();
        }

        public Builder answer(IssueAnswer answer) {
            Checks.isNotNull((Object)answer, (String)"answer");
            IssueAnswer current = this.issueIdToAnswer.get(answer.getIssueId());
            this.answers.remove(current);
            this.answers.add(answer);
            this.issueIdToAnswer.put(answer.getIssueId(), answer);
            this.answers.add(answer);
            return this.self();
        }

        public IssuesAndAnswers build() {
            return new IssuesAndAnswerImpl(this);
        }
    }
}

