/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.io;

import cdc.office.ss.WorkbookWriterFeatures;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.EnumSet;
import java.util.Set;

public final class IssuesIoFactoryFeatures {
    public static final IssuesIoFactoryFeatures UTC_BEST = IssuesIoFactoryFeatures.builder().workbookWriterFeatures(WorkbookWriterFeatures.builder().enable(WorkbookWriterFeatures.Feature.AUTO_FILTER_COLUMNS).enable(WorkbookWriterFeatures.Feature.AUTO_SIZE_COLUMNS).enable(WorkbookWriterFeatures.Feature.AUTO_SIZE_ROWS).enable(WorkbookWriterFeatures.Feature.TRUNCATE_CELLS).build()).hint(Hint.PRETTY_PRINT).zoneId(ZoneOffset.UTC).hint(Hint.POI_STREAMING).hint(Hint.ZIP32).build();
    public static final IssuesIoFactoryFeatures UTC_BEST_VERBOSE = IssuesIoFactoryFeatures.builder().set(UTC_BEST).hint(Hint.VERBOSE).build();
    public static final IssuesIoFactoryFeatures UTC_FASTEST = IssuesIoFactoryFeatures.builder().workbookWriterFeatures(WorkbookWriterFeatures.builder().enable(WorkbookWriterFeatures.Feature.AUTO_FILTER_COLUMNS).enable(WorkbookWriterFeatures.Feature.TRUNCATE_CELLS).build()).hint(Hint.PRETTY_PRINT).zoneId(ZoneOffset.UTC).hint(Hint.POI_STREAMING).hint(Hint.ZIP32).build();
    public static final IssuesIoFactoryFeatures UTC_FASTEST_VERBOSE = IssuesIoFactoryFeatures.builder().set(UTC_FASTEST).hint(Hint.VERBOSE).build();
    private final WorkbookWriterFeatures workbookWriterFeatures;
    private final Set<Hint> hints = EnumSet.noneOf(Hint.class);
    private final ZoneId zoneId;
    private final String password;

    private IssuesIoFactoryFeatures(Builder builder) {
        this.workbookWriterFeatures = builder.workbookWriterFeatures;
        this.hints.addAll(builder.hints);
        this.zoneId = builder.zoneId;
        this.password = builder.password;
    }

    public WorkbookWriterFeatures getWorkbookWriterFeatures() {
        return this.workbookWriterFeatures;
    }

    public boolean isEnabled(Hint hint) {
        return this.hints.contains((Object)hint);
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public String getPassword() {
        return this.password;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Hint {
        VERBOSE,
        PRETTY_PRINT,
        ODS_FAST,
        ODS_SIMPLE,
        POI_STREAMING,
        ZIP32;

    }

    public static final class Builder {
        private WorkbookWriterFeatures workbookWriterFeatures = WorkbookWriterFeatures.STANDARD_FAST;
        private final Set<Hint> hints = EnumSet.noneOf(Hint.class);
        private ZoneId zoneId = ZoneOffset.UTC;
        private String password = null;

        protected Builder() {
        }

        public Builder set(IssuesIoFactoryFeatures other) {
            this.workbookWriterFeatures(other.getWorkbookWriterFeatures());
            this.zoneId(other.getZoneId());
            this.password(other.getPassword());
            this.hints.addAll(other.hints);
            return this;
        }

        public Builder workbookWriterFeatures(WorkbookWriterFeatures features) {
            this.workbookWriterFeatures = features;
            return this;
        }

        public Builder hint(Hint hint) {
            this.hints.add(hint);
            return this;
        }

        public Builder zoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public IssuesIoFactoryFeatures build() {
            return new IssuesIoFactoryFeatures(this);
        }
    }
}

