/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.io;

import cdc.office.ss.WorkbookKind;
import cdc.util.files.Files;
import cdc.util.lang.UnexpectedValueException;
import java.io.File;

public enum ProfileFormat {
    CSV,
    ODS,
    XLS,
    XLSM,
    XLSX,
    MDB,
    ACCDB,
    JSON,
    XML,
    HTML,
    MD;


    public WorkbookKind getWorkbookKind() {
        return switch (this) {
            case CSV -> WorkbookKind.CSV;
            case ODS -> WorkbookKind.ODS;
            case XLS -> WorkbookKind.XLS;
            case XLSX -> WorkbookKind.XLSX;
            case XLSM -> WorkbookKind.XLSM;
            case MDB -> WorkbookKind.MDB;
            case ACCDB -> WorkbookKind.ACCDB;
            default -> throw new UnexpectedValueException((Enum)this);
        };
    }

    public boolean isProfileExportFormat() {
        return true;
    }

    public boolean isProfileConfigExportFormat() {
        return this == CSV || this == ODS || this == XLS || this == XLSX || this == XLSM || this == MDB || this == ACCDB;
    }

    public boolean isProfileImportFormat() {
        return this == XML;
    }

    public boolean isProfileConfigImportFormat() {
        return this == CSV || this == ODS || this == XLS || this == XLSX || this == XLSM || this == MDB || this == ACCDB;
    }

    public static ProfileFormat from(File file) {
        String ext = Files.getExtension((File)file);
        for (ProfileFormat format : ProfileFormat.values()) {
            if (!format.name().equalsIgnoreCase(ext)) continue;
            return format;
        }
        return null;
    }
}

