/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.rules;

import cdc.issues.Labels;
import cdc.issues.Metas;
import cdc.issues.rules.ConfiguredRule;
import cdc.issues.rules.Profile;
import cdc.issues.rules.ProfileConfig;
import cdc.issues.rules.Rule;
import cdc.issues.rules.RuleId;
import cdc.util.lang.Checks;
import cdc.util.lang.NotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class ProfileImpl
implements Profile {
    private static final String RULE = "rule";
    private final String name;
    private String description = "";
    private Metas metas = Metas.NO_METAS;
    private Labels labels = Labels.NO_LABELS;
    private final Map<RuleId, ConfiguredRule> configuredRules = new HashMap<RuleId, ConfiguredRule>();

    protected ProfileImpl(Profile.Builder builder) {
        this.name = (String)Checks.isNotNull((Object)builder.name, (String)"name");
        this.description = (String)Checks.isNotNull((Object)builder.description, (String)"description");
        this.metas = builder.metas.build();
        this.labels = (Labels)Checks.isNotNull((Object)builder.labels, (String)"labels");
        for (Map.Entry<RuleId, ConfiguredRule.Builder> entry : builder.configuredRules.entrySet()) {
            this.configuredRules.put(entry.getKey(), entry.getValue().build());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Metas getMetas() {
        return this.metas;
    }

    @Override
    public Labels getLabels() {
        return this.labels;
    }

    @Override
    public Optional<Rule> getRule(RuleId ruleId) {
        if (this.configuredRules.containsKey(ruleId)) {
            return Optional.ofNullable(this.configuredRules.get(ruleId).getRule());
        }
        return Optional.empty();
    }

    @Override
    public Set<Rule> getRules() {
        return this.configuredRules.values().stream().map(ConfiguredRule::getRule).collect(Collectors.toSet());
    }

    @Override
    public boolean hasRule(Rule rule) {
        return rule != null && this.configuredRules.containsKey(rule.getId());
    }

    @Override
    public ProfileConfig getProfileConfig() {
        ProfileConfig.Builder result = ProfileConfig.builder();
        for (ConfiguredRule cr : this.configuredRules.values()) {
            result.set(cr.getRule().getId(), cr.getConfig());
        }
        return result.build();
    }

    @Override
    public boolean hasRule(RuleId ruleId) {
        return this.configuredRules.containsKey(ruleId);
    }

    @Override
    public ConfiguredRule getConfiguredRule(Rule rule) {
        Checks.isNotNull((Object)rule, (String)RULE);
        ConfiguredRule result = this.configuredRules.get(rule.getId());
        if (result == null) {
            throw new NotFoundException("Unknown rule " + String.valueOf(rule.getId()));
        }
        return result;
    }
}

