/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.Issue;
import cdc.issues.IssueId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class IssueUtils {
    private IssueUtils() {
    }

    public static Set<String> getMetaNames(Collection<? extends Issue> issues) {
        HashSet<String> set = new HashSet<String>();
        for (Issue issue : issues) {
            set.addAll(issue.getMetas().getNames());
        }
        return set;
    }

    public static Set<String> getParamNames(Collection<? extends Issue> issues) {
        HashSet<String> set = new HashSet<String>();
        for (Issue issue : issues) {
            set.addAll(issue.getParams().getNames());
        }
        return set;
    }

    public static String getHash(Collection<? extends Issue> issues) {
        return IssueUtils.getHash(issues.stream().map(Issue::getId).toList());
    }

    public static String getHash(List<IssueId> issueIds) {
        ArrayList<IssueId> list = new ArrayList<IssueId>(issueIds);
        Collections.sort(list);
        int hash = 0;
        for (IssueId id : list) {
            hash += 31 * id.hashCode();
        }
        return Integer.toHexString(hash).toUpperCase();
    }
}

