/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.NameValue;
import cdc.issues.Param;
import cdc.issues.Params;
import cdc.util.lang.Checks;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

record ParamsImpl(Map<String, String> map) implements Params
{
    ParamsImpl {
        for (String name : map.keySet()) {
            Checks.isTrue((boolean)Param.isValidName(name), (String)"name: '{}'", (Object)name);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> getNames() {
        return this.map.keySet();
    }

    @Override
    public List<String> getSortedNames() {
        return this.map.keySet().stream().sorted().toList();
    }

    @Override
    public String getValue(String name) {
        return this.map.get(name);
    }

    @Override
    public String getValue(String name, String def) {
        return this.map.getOrDefault(name, def);
    }

    @Override
    public Collection<Param> getParams() {
        return this.map.keySet().stream().map(name -> Param.of(name, this.getValue((String)name))).toList();
    }

    @Override
    public List<Param> getSortedParams() {
        return this.map.keySet().stream().sorted().map(name -> Param.of(name, this.getValue((String)name))).toList();
    }

    @Override
    public String toString() {
        return this.getSortedParams().stream().map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    public Collection<? extends NameValue> getNameValues() {
        return this.getParams();
    }

    @Override
    public List<? extends NameValue> getSortedNameValues() {
        return this.getSortedParams();
    }

    @Override
    public int compareTo(Params other) {
        return this.toString().compareTo(other.toString());
    }
}

