/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.Issue;
import cdc.issues.IssueUtils;
import cdc.issues.Labels;
import cdc.issues.Metas;
import cdc.issues.Project;
import cdc.issues.ProjectImpl;
import cdc.issues.Snapshot;
import java.time.Instant;
import java.util.List;
import java.util.Optional;

class SnapshotImpl
implements Snapshot {
    final Optional<Project> project;
    final String name;
    final String description;
    final Metas metas;
    final Labels labels;
    final Instant timestamp;
    final List<Issue> issues;
    final String issuesHash;

    public SnapshotImpl(Snapshot.Builder builder) {
        this.project = Optional.ofNullable(builder.project);
        this.name = builder.name;
        this.description = builder.description;
        this.metas = builder.metas.build();
        this.labels = builder.labels;
        this.timestamp = builder.timestamp;
        this.issues = List.copyOf(builder.issues);
        this.issuesHash = IssueUtils.getHash(this.issues);
        Project p = this.project.orElse(null);
        if (p instanceof ProjectImpl) {
            ProjectImpl pi = (ProjectImpl)p;
            pi.snapshots.add(this);
        }
    }

    @Override
    public Optional<Project> getProject() {
        return this.project;
    }

    @Override
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Metas getMetas() {
        return this.metas;
    }

    @Override
    public Labels getLabels() {
        return this.labels;
    }

    @Override
    public List<Issue> getIssues() {
        return this.issues;
    }

    @Override
    public String getIssuesHash() {
        return this.issuesHash;
    }
}

