/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.Issue;
import cdc.issues.IssueSeverity;
import cdc.issues.IssuesHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VerboseIssuesHandler
implements IssuesHandler {
    private static final Logger LOGGER = LogManager.getLogger(VerboseIssuesHandler.class);
    private final IssuesHandler delegate;

    public VerboseIssuesHandler(IssuesHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public void issue(Issue issue) {
        if (issue.getSeverity() == IssueSeverity.INFO) {
            LOGGER.info((Object)issue);
        } else if (issue.getSeverity() == IssueSeverity.MINOR || issue.getSeverity() == IssueSeverity.MAJOR) {
            LOGGER.warn((Object)issue);
        } else if (issue.getSeverity() == IssueSeverity.CRITICAL) {
            LOGGER.error((Object)issue);
        } else if (issue.getSeverity() == IssueSeverity.BLOCKER) {
            LOGGER.fatal((Object)issue);
        }
        this.delegate.issue(issue);
    }
}

