/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.answers;

import cdc.issues.Issue;
import cdc.issues.IssueId;
import cdc.issues.answers.IssueAnswer;
import cdc.issues.answers.IssuesAndAnswers;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class IssuesAndAnswerImpl
implements IssuesAndAnswers {
    private final List<Issue> issues;
    private final Set<IssueAnswer> answers;
    private final Map<IssueId, IssueAnswer> issueIdToAnswer;

    IssuesAndAnswerImpl(IssuesAndAnswers.Builder builder) {
        this.issues = List.copyOf(builder.issues);
        this.answers = Set.copyOf(builder.answers);
        this.issueIdToAnswer = Map.copyOf(builder.issueIdToAnswer);
    }

    @Override
    public List<Issue> getIssues() {
        return this.issues;
    }

    public Set<IssueAnswer> getAnswers() {
        return this.answers;
    }

    @Override
    public Optional<IssueAnswer> getAnswer(IssueId id) {
        return Optional.ofNullable(this.issueIdToAnswer.get(id));
    }
}

