/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.io;

import cdc.issues.Issue;
import cdc.issues.Snapshot;
import cdc.issues.answers.IssuesAndAnswers;
import cdc.issues.io.IssuesFormat;
import cdc.issues.io.IssuesIoFactory;
import cdc.issues.io.IssuesIoFactoryFeatures;
import cdc.issues.io.OutSettings;
import cdc.issues.io.SnapshotData;
import cdc.util.events.ProgressController;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public interface IssuesWriter {
    public void save(IssuesAndAnswers var1, OutSettings var2, ProgressController var3) throws IOException;

    public void save(List<? extends Issue> var1, OutSettings var2, ProgressController var3) throws IOException;

    public void save(Snapshot var1, OutSettings var2, ProgressController var3) throws IOException;

    public void save(SnapshotData var1, List<? extends Issue> var2, OutSettings var3, ProgressController var4) throws IOException;

    public void save(SnapshotData var1, IssuesAndAnswers var2, OutSettings var3, ProgressController var4) throws IOException;

    public static void save(IssuesAndAnswers issuesAndAnswers, OutSettings settings, File file, ProgressController controller, IssuesIoFactoryFeatures features) throws IOException {
        IssuesIoFactory factory = new IssuesIoFactory(features);
        IssuesWriter writer = factory.createIssuesWriter(file);
        writer.save(issuesAndAnswers, settings, controller);
    }

    public static void save(List<? extends Issue> issues, OutSettings settings, File file, ProgressController controller, IssuesIoFactoryFeatures features) throws IOException {
        IssuesIoFactory factory = new IssuesIoFactory(features);
        IssuesWriter writer = factory.createIssuesWriter(file);
        writer.save(issues, settings, controller);
    }

    public static void save(List<? extends Issue> issues, File file, ProgressController controller, IssuesIoFactoryFeatures features) throws IOException {
        IssuesWriter.save(issues, OutSettings.ALL_DATA_NO_ANSWERS, file, controller, features);
    }

    public static void save(Snapshot snapshot, OutSettings settings, File file, ProgressController controller, IssuesIoFactoryFeatures features) throws IOException {
        IssuesIoFactory factory = new IssuesIoFactory(features);
        IssuesWriter writer = factory.createIssuesWriter(file);
        writer.save(snapshot, settings, controller);
    }

    public static void save(IssuesAndAnswers issuesAndAnswers, OutSettings settings, OutputStream out, IssuesFormat format, ProgressController controller, IssuesIoFactoryFeatures features) throws IOException {
        IssuesIoFactory factory = new IssuesIoFactory(features);
        IssuesWriter writer = factory.createIssuesWriter(out, format);
        writer.save(issuesAndAnswers, settings, controller);
    }

    public static void save(List<? extends Issue> issues, OutSettings settings, OutputStream out, IssuesFormat format, ProgressController controller, IssuesIoFactoryFeatures features) throws IOException {
        IssuesIoFactory factory = new IssuesIoFactory(features);
        IssuesWriter writer = factory.createIssuesWriter(out, format);
        writer.save(issues, settings, controller);
    }

    public static void save(List<? extends Issue> issues, OutputStream out, IssuesFormat format, ProgressController controller, IssuesIoFactoryFeatures features) throws IOException {
        IssuesWriter.save(issues, OutSettings.ALL_DATA_NO_ANSWERS, out, format, controller, features);
    }

    public static void save(SnapshotData synthesis, List<? extends Issue> issues, OutSettings settings, File file, ProgressController controller, IssuesIoFactoryFeatures features) throws IOException {
        IssuesIoFactory factory = new IssuesIoFactory(features);
        IssuesWriter writer = factory.createIssuesWriter(file);
        writer.save(synthesis, issues, settings, controller);
    }
}

