/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.rules;

import cdc.util.lang.Checks;
import java.util.Objects;

public class RuleId
implements Comparable<RuleId> {
    private static final String DOMAIN = "domain";
    private static final String NAME = "name";
    private final String domain;
    private final String name;
    public static final RuleId NONE = new RuleId("???", "???");

    private static String getDomain(String s) {
        int loc = s.indexOf(47);
        return s.substring(0, loc);
    }

    private static String getName(String s) {
        int loc = s.indexOf(47);
        return s.substring(loc + 1);
    }

    public RuleId(String domain, String name) {
        this.domain = (String)Checks.isNotNull((Object)domain, (String)DOMAIN);
        this.name = (String)Checks.isNotNull((Object)name, (String)NAME);
    }

    public RuleId(String s) {
        this(RuleId.getDomain(s), RuleId.getName(s));
    }

    public RuleId(String domain, Enum<?> name) {
        this.domain = (String)Checks.isNotNull((Object)domain, (String)DOMAIN);
        this.name = ((Enum)Checks.isNotNull(name, (String)NAME)).name();
    }

    public String getDomain() {
        return this.domain;
    }

    public String getName() {
        return this.name;
    }

    public <T extends Enum<T>> T getName(Class<T> cls) {
        return Enum.valueOf(cls, this.name);
    }

    public int hashCode() {
        return Objects.hash(this.domain, this.name);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RuleId)) {
            return false;
        }
        RuleId other = (RuleId)object;
        return this.domain.equals(other.domain) && this.name.equals(other.name);
    }

    @Override
    public int compareTo(RuleId other) {
        int domainCmp = this.domain.compareTo(other.domain);
        if (domainCmp == 0) {
            return this.name.compareTo(other.name);
        }
        return domainCmp;
    }

    public String toString() {
        return this.domain + "/" + this.name;
    }
}

