/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.FormalParam;
import cdc.issues.FormalParamsImpl;
import cdc.util.lang.Checks;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface FormalParams {
    public static final FormalParams NO_PARAMS = FormalParams.builder().build();

    public boolean isEmpty();

    public Set<String> getNames();

    public List<String> getSortedNames();

    public List<FormalParam> getSortedParams();

    public FormalParam getParam(String var1);

    public String getDescription(String var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, FormalParam> map = new HashMap<String, FormalParam>();
        private static final String NAME = "name";

        private Builder() {
        }

        public Builder param(String name, String description) {
            Checks.isNotNull((Object)name, (String)NAME);
            this.map.put(name, FormalParam.of(name, description));
            return this;
        }

        public FormalParams build() {
            return new FormalParamsImpl(this.map);
        }
    }
}

