/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.DataSource;
import cdc.issues.IssueId;
import cdc.issues.Labels;
import cdc.issues.LabelsBuilding;
import cdc.issues.LabelsItem;
import cdc.issues.Metas;
import cdc.issues.MetasBuilding;
import cdc.issues.MetasItem;
import cdc.issues.ProjectImpl;
import cdc.issues.Snapshot;
import cdc.issues.answers.IssueAnswer;
import cdc.issues.rules.Profile;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface Project
extends MetasItem,
LabelsItem {
    public String getName();

    public String getDescription();

    public Optional<Profile> getProfile();

    @Deprecated(since="2025-03-29", forRemoval=true)
    public Iterable<DataSource<?>> getDataSources();

    public List<? extends Snapshot> getSnapshots();

    public Set<? extends IssueAnswer> getAnswers();

    public Optional<IssueAnswer> getAnswer(IssueId var1);

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements MetasBuilding<Builder>,
    LabelsBuilding<Builder> {
        String name;
        String description;
        final Metas.Builder metas = Metas.builder();
        Labels labels = Labels.NO_LABELS;
        Profile profile;
        final Map<IssueId, IssueAnswer> idToAnswers = new HashMap<IssueId, IssueAnswer>();
        final Set<IssueAnswer> answers = new HashSet<IssueAnswer>();

        Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return (Builder)this.self();
        }

        public Builder description(String description) {
            this.description = description;
            return (Builder)this.self();
        }

        @Override
        public Builder meta(String name, String value) {
            this.metas.meta(name, value);
            return (Builder)this.self();
        }

        @Override
        public Builder meta(String name, String value, String separator) {
            this.metas.meta(name, value, separator);
            return (Builder)this.self();
        }

        @Override
        public Builder metas(Metas metas) {
            this.metas.metas(metas);
            return (Builder)this.self();
        }

        @Override
        public Builder labels(Labels labels) {
            this.labels = labels;
            return (Builder)this.self();
        }

        public Builder profile(Profile profile) {
            this.profile = profile;
            return (Builder)this.self();
        }

        public Builder answer(IssueAnswer answer) {
            IssueAnswer current = this.idToAnswers.get(answer.getIssueId());
            this.answers.remove(current);
            this.answers.add(answer);
            this.idToAnswers.put(answer.getIssueId(), answer);
            return (Builder)this.self();
        }

        public Builder answers(Collection<? extends IssueAnswer> answers) {
            for (IssueAnswer issueAnswer : answers) {
                this.answer(issueAnswer);
            }
            return (Builder)this.self();
        }

        public Project build() {
            return new ProjectImpl(this);
        }
    }
}

