/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.DataSource;
import cdc.issues.IssueId;
import cdc.issues.Labels;
import cdc.issues.Metas;
import cdc.issues.Project;
import cdc.issues.Snapshot;
import cdc.issues.answers.IssueAnswer;
import cdc.issues.rules.Profile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class ProjectImpl
implements Project {
    private final String name;
    private final String description;
    private final Metas metas;
    private final Labels labels;
    private final Optional<Profile> profile;
    final List<Snapshot> snapshots = new ArrayList<Snapshot>();
    private final Map<IssueId, IssueAnswer> idToAnswers;
    private final Set<IssueAnswer> answers;

    ProjectImpl(Project.Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.metas = builder.metas.build();
        this.labels = builder.labels;
        this.profile = Optional.ofNullable(builder.profile);
        this.idToAnswers = Map.copyOf(builder.idToAnswers);
        this.answers = Set.copyOf(builder.answers);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Metas getMetas() {
        return this.metas;
    }

    @Override
    public Labels getLabels() {
        return this.labels;
    }

    @Override
    public Optional<Profile> getProfile() {
        return this.profile;
    }

    @Override
    public Iterable<DataSource<?>> getDataSources() {
        return Collections.emptyList();
    }

    @Override
    public List<? extends Snapshot> getSnapshots() {
        return this.snapshots;
    }

    @Override
    public Set<? extends IssueAnswer> getAnswers() {
        return this.answers;
    }

    @Override
    public Optional<IssueAnswer> getAnswer(IssueId id) {
        return Optional.ofNullable(this.idToAnswers.get(id));
    }
}

