/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.io;

import cdc.office.ss.WorkbookKind;
import cdc.util.files.Files;
import cdc.util.lang.UnexpectedValueException;
import java.io.File;

public enum IssuesFormat {
    CSV,
    ODS,
    XLS,
    XLSM,
    XLSX,
    MDB,
    ACCDB,
    JSON,
    XML;


    public WorkbookKind getWorkbookKind() {
        return switch (this) {
            case CSV -> WorkbookKind.CSV;
            case ODS -> WorkbookKind.ODS;
            case XLS -> WorkbookKind.XLS;
            case XLSX -> WorkbookKind.XLSX;
            case XLSM -> WorkbookKind.XLSM;
            case MDB -> WorkbookKind.MDB;
            case ACCDB -> WorkbookKind.ACCDB;
            default -> throw new UnexpectedValueException((Enum)this);
        };
    }

    public boolean isExportFormat() {
        return true;
    }

    public boolean isImportFormat() {
        return true;
    }

    public static IssuesFormat from(File file) {
        String ext = Files.getExtension((File)file);
        for (IssuesFormat format : IssuesFormat.values()) {
            if (!format.name().equalsIgnoreCase(ext)) continue;
            return format;
        }
        return null;
    }
}

