/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.io;

import cdc.office.ss.WorkbookWriterFeatures;
import cdc.util.lang.Checks;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;

public final class ProfileIoFeatures {
    public static final ProfileIoFeatures BEST = ProfileIoFeatures.builder().workbookWriterFeatures(WorkbookWriterFeatures.builder().enable(WorkbookWriterFeatures.Feature.AUTO_FILTER_COLUMNS).enable(WorkbookWriterFeatures.Feature.AUTO_SIZE_COLUMNS).enable(WorkbookWriterFeatures.Feature.AUTO_SIZE_ROWS).enable(WorkbookWriterFeatures.Feature.TRUNCATE_CELLS).build()).hint(Hint.PRETTY_PRINT).build();
    public static final ProfileIoFeatures FASTEST = ProfileIoFeatures.builder().workbookWriterFeatures(WorkbookWriterFeatures.builder().enable(WorkbookWriterFeatures.Feature.AUTO_FILTER_COLUMNS).enable(WorkbookWriterFeatures.Feature.TRUNCATE_CELLS).build()).hint(Hint.PRETTY_PRINT).hint(Hint.POI_STREAMING).build();
    private final WorkbookWriterFeatures workbookWriterFeatures;
    private final Set<Hint> hints = EnumSet.noneOf(Hint.class);
    private final List<String> sections;
    private final UnaryOperator<String> itemConverter;

    private ProfileIoFeatures(Builder builder) {
        this.workbookWriterFeatures = builder.workbookWriterFeatures;
        this.hints.addAll(builder.hints);
        this.sections = List.copyOf(builder.sections);
        this.itemConverter = (UnaryOperator)Checks.isNotNull(builder.itemConverter, (String)"itemConverter");
    }

    public WorkbookWriterFeatures getWorkbookWriterFeatures() {
        return this.workbookWriterFeatures;
    }

    public boolean isEnabled(Hint hint) {
        return this.hints.contains((Object)hint);
    }

    public List<String> getSections() {
        return this.sections;
    }

    public UnaryOperator<String> getItemConverter() {
        return this.itemConverter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Hint {
        PRETTY_PRINT,
        ODS_FAST,
        ODS_SIMPLE,
        POI_STREAMING,
        SHOW_EMPTY_SECTIONS,
        SHOW_RULE_SEVERITY,
        SHOW_RULE_ENABLING,
        SHOW_RULE_DOMAIN;

    }

    public static final class Builder {
        private WorkbookWriterFeatures workbookWriterFeatures = WorkbookWriterFeatures.builder().enable(WorkbookWriterFeatures.Feature.AUTO_FILTER_COLUMNS).enable(WorkbookWriterFeatures.Feature.AUTO_SIZE_COLUMNS).enable(WorkbookWriterFeatures.Feature.AUTO_SIZE_ROWS).enable(WorkbookWriterFeatures.Feature.TRUNCATE_CELLS).build();
        private final Set<Hint> hints = EnumSet.noneOf(Hint.class);
        private final List<String> sections = new ArrayList<String>();
        private UnaryOperator<String> itemConverter = UnaryOperator.identity();

        protected Builder() {
        }

        public Builder workbookWriterFeatures(WorkbookWriterFeatures features) {
            this.workbookWriterFeatures = features;
            return this;
        }

        public Builder hint(Hint hint) {
            this.hints.add(hint);
            return this;
        }

        public Builder sections(List<String> sections) {
            this.sections.clear();
            this.sections.addAll(sections);
            return this;
        }

        public Builder sections(String ... sections) {
            return this.sections(List.of(sections));
        }

        public Builder itemConverter(UnaryOperator<String> itemConverter) {
            this.itemConverter = itemConverter;
            return this;
        }

        public ProfileIoFeatures build() {
            return new ProfileIoFeatures(this);
        }
    }
}

