/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.rules;

import cdc.issues.IssueSeverity;
import cdc.issues.Labels;
import cdc.issues.LabelsBuilding;
import cdc.issues.LabelsItem;
import cdc.issues.Metas;
import cdc.issues.MetasBuilding;
import cdc.issues.MetasItem;
import cdc.issues.Params;
import cdc.issues.rules.ConfiguredRule;
import cdc.issues.rules.ProfileConfig;
import cdc.issues.rules.ProfileImpl;
import cdc.issues.rules.Rule;
import cdc.issues.rules.RuleConfig;
import cdc.issues.rules.RuleId;
import cdc.util.lang.Checks;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface Profile
extends MetasItem,
LabelsItem {
    public static final Profile EMPTY = Profile.builder().name("Empty").build();

    public String getName();

    public String getDescription();

    public Set<Rule> getRules();

    default public boolean hasRule(Rule rule) {
        return this.getRules().contains(rule);
    }

    default public Set<Rule> getEnabledRules() {
        return this.getRules().stream().filter(this::isEnabled).collect(Collectors.toSet());
    }

    public ProfileConfig getProfileConfig();

    default public boolean hasRule(RuleId ruleId) {
        return this.getProfileConfig().getRuleIds().contains(ruleId);
    }

    public Optional<Rule> getRule(RuleId var1);

    public ConfiguredRule getConfiguredRule(Rule var1);

    default public RuleConfig getRuleConfig(Rule rule) {
        return this.getConfiguredRule(rule).getConfig();
    }

    default public boolean isEnabled(Rule rule) {
        return this.getConfiguredRule(rule).isEnabled();
    }

    default public Optional<IssueSeverity> getCustomizedSeverity(Rule rule) {
        return this.getConfiguredRule(rule).getCustomizedSeverity();
    }

    default public IssueSeverity getEffectiveSeverity(Rule rule) {
        return this.getConfiguredRule(rule).getEffectiveSeverity();
    }

    default public Params getParams(Rule rule) {
        return this.getConfiguredRule(rule).getParams();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements MetasBuilding<Builder>,
    LabelsBuilding<Builder> {
        String name;
        String description = "";
        final Metas.Builder metas = Metas.builder();
        Labels labels = Labels.NO_LABELS;
        final Map<RuleId, ConfiguredRule.Builder> configuredRules = new HashMap<RuleId, ConfiguredRule.Builder>();

        Builder() {
        }

        public Builder profile(Profile profile) {
            this.name(profile.getName());
            this.description(profile.getDescription());
            this.metas(profile.getMetas());
            this.labels(profile.getLabels());
            for (Rule rule : profile.getRules()) {
                this.rule(rule);
                this.enabled(rule, profile.isEnabled(rule));
                if (!profile.getCustomizedSeverity(rule).isPresent()) continue;
                this.customizedSeverity(rule, profile.getCustomizedSeverity(rule).orElseThrow());
            }
            return (Builder)this.self();
        }

        public boolean containsRule(RuleId ruleId) {
            return this.configuredRules.containsKey(ruleId);
        }

        public Optional<Rule> getRule(RuleId ruleId) {
            if (this.containsRule(ruleId)) {
                return Optional.of(this.configuredRules.get(ruleId).getRule());
            }
            return Optional.empty();
        }

        public Builder name(String name) {
            this.name = name;
            return (Builder)this.self();
        }

        public Builder description(String description) {
            this.description = description;
            return (Builder)this.self();
        }

        @Override
        public Builder meta(String name, String value) {
            this.metas.meta(name, value);
            return (Builder)this.self();
        }

        @Override
        public Builder meta(String name, String value, String separator) {
            this.metas.meta(name, value, separator);
            return (Builder)this.self();
        }

        @Override
        public Builder metas(Metas metas) {
            this.metas.metas(metas);
            return (Builder)this.self();
        }

        @Override
        public Builder labels(Labels labels) {
            this.labels = labels;
            return (Builder)this.self();
        }

        public Builder rules(Profile profile) {
            for (Rule rule : profile.getRules()) {
                this.rule(rule);
            }
            return (Builder)this.self();
        }

        public Builder rule(Rule rule) {
            Checks.isNotNull((Object)rule, (String)"rule");
            Checks.assertFalse((boolean)this.configuredRules.containsKey(rule.getId()), (String)"Duplicate rule id {} in '{}', cannot add '{}'.", (Object)rule.getId(), (Object)this.name, (Object)rule.getTitle());
            this.configuredRules.put(rule.getId(), ConfiguredRule.builder(rule));
            return (Builder)this.self();
        }

        public Builder enabled(Rule rule, boolean enabled) {
            ConfiguredRule.Builder b = this.configuredRules.computeIfAbsent(rule.getId(), k -> ConfiguredRule.builder(rule));
            b.enabled(enabled);
            return (Builder)this.self();
        }

        public Builder enabled(RuleId ruleId, boolean enabled) {
            Checks.isTrue((boolean)this.containsRule(ruleId), (String)"Unknown rule {}", (Object)ruleId);
            this.enabled(this.getRule(ruleId).orElseThrow(), enabled);
            return (Builder)this.self();
        }

        public Builder allEnabled(boolean enabled) {
            for (ConfiguredRule.Builder b : this.configuredRules.values()) {
                b.enabled(enabled);
            }
            return (Builder)this.self();
        }

        public Builder customizedSeverity(Rule rule, IssueSeverity customizedSeverity) {
            ConfiguredRule.Builder b = this.configuredRules.computeIfAbsent(rule.getId(), k -> ConfiguredRule.builder(rule));
            b.customizedSeverity(customizedSeverity);
            return (Builder)this.self();
        }

        public Builder params(Rule rule, Params params) {
            ConfiguredRule.Builder b = this.configuredRules.computeIfAbsent(rule.getId(), k -> ConfiguredRule.builder(rule));
            b.params(params);
            return (Builder)this.self();
        }

        public Builder config(Rule rule, RuleConfig config) {
            ConfiguredRule.Builder b = this.configuredRules.computeIfAbsent(rule.getId(), k -> ConfiguredRule.builder(rule));
            b.config(config);
            return (Builder)this.self();
        }

        public Builder config(RuleId ruleId, RuleConfig config) {
            Checks.isTrue((boolean)this.containsRule(ruleId), (String)"Unknown rule {}", (Object)ruleId);
            return this.config(this.getRule(ruleId).orElseThrow(), config);
        }

        public Builder config(ProfileConfig profileConfig) {
            for (RuleId ruleId : profileConfig.getRuleIds()) {
                if (!this.containsRule(ruleId)) continue;
                RuleConfig config = profileConfig.getRuleConfig(ruleId).orElseThrow();
                this.config(ruleId, config);
            }
            return (Builder)this.self();
        }

        public ProfileImpl build() {
            return new ProfileImpl(this);
        }
    }
}

