/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.rules;

import cdc.issues.StructuredDescription;
import cdc.util.lang.UnexpectedValueException;
import cdc.util.strings.StringUtils;
import java.util.Collection;

public class RuleDescription
extends StructuredDescription {
    public static final String SECTION_APPLIES_TO = "Applies to";
    public static final String SECTION_EXCEPTIONS = "Exceptions";
    public static final String SECTION_REMARKS = "Remarks";
    public static final String SECTION_RELATED_TO = "Related to";
    public static final String SECTION_SOURCES = "Sources";
    public static final String A = "a";
    public static final String AN = "an";
    public static final String ANY = "any";
    public static final String SOME = "some";
    public static final String THE = "the";
    public static final String ALL = "all";

    protected RuleDescription(Builder<?> builder) {
        super(builder);
    }

    private static String toCapital(String s) {
        if (StringUtils.isNullOrEmpty((String)s)) {
            return "";
        }
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        if (s.length() == 1) {
            return Character.toString(Character.toUpperCase(s.charAt(0)));
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    private static String toLower(String s) {
        if (StringUtils.isNullOrEmpty((String)s)) {
            return "";
        }
        return s.toLowerCase();
    }

    private static String toCase(String s, boolean capital) {
        return capital ? RuleDescription.toCapital(s) : RuleDescription.toLower(s);
    }

    private static String mdEscape(String s) {
        if (StringUtils.isNullOrEmpty((String)s)) {
            return "";
        }
        return s.replace("*", "\\*").replace("_", "\\_");
    }

    private static String format(String specifier, Object arg) {
        String s = arg == null ? "" : arg.toString();
        switch (specifier) {
            case "s": {
                return s;
            }
            case "wrap": {
                return "[" + s + "]";
            }
            case "capital": {
                if (arg == null) {
                    return "";
                }
                return RuleDescription.toCapital(s) + " ";
            }
            case "lower": {
                if (arg == null) {
                    return "";
                }
                return RuleDescription.toLower(s) + " ";
            }
            case "md-escape": {
                return RuleDescription.mdEscape(s);
            }
        }
        throw new UnexpectedValueException("Invalid specifier: " + specifier);
    }

    public static String format(String format, Object ... args) {
        return StringUtils.format((String)format, RuleDescription::format, (Object[])args);
    }

    public static String wrap(String item) {
        return "[" + item + "]";
    }

    private static String wrap(String article, String item) {
        return StringUtils.isNullOrEmpty((String)article) ? RuleDescription.wrap(item) : article + " " + RuleDescription.wrap(item);
    }

    public static String wrap(String article, boolean capital, String item) {
        return RuleDescription.wrap(RuleDescription.toCase(article, capital), item);
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<B extends Builder<B>>
    extends StructuredDescription.Builder<B> {
        protected Builder() {
        }

        public B define(String format, Object ... args) {
            return (B)((Builder)this.text(RuleDescription.format(format, args)));
        }

        public B wrap(String item) {
            return (B)((Builder)this.text(RuleDescription.wrap(item)));
        }

        public B wrap(String article, boolean capital, String item) {
            return (B)((Builder)this.text(RuleDescription.wrap(article, capital, item)));
        }

        public B remarks(String ... remarks) {
            this.section(RuleDescription.SECTION_REMARKS);
            return (B)((Builder)this.uItems(remarks));
        }

        public B remarks(Collection<String> remarks) {
            return this.remarks((String[])remarks.toArray(String[]::new));
        }

        public B sources(String ... sources) {
            this.section(RuleDescription.SECTION_SOURCES);
            return (B)((Builder)this.uItems(sources));
        }

        public B sources(Collection<String> sources) {
            return this.sources((String[])sources.toArray(String[]::new));
        }

        public B appliesTo(String ... items) {
            this.section(RuleDescription.SECTION_APPLIES_TO);
            return (B)((Builder)this.uItems(items));
        }

        public B appliesTo(Collection<String> items) {
            return this.appliesTo((String[])items.toArray(String[]::new));
        }

        public B exceptions(String ... items) {
            this.section(RuleDescription.SECTION_EXCEPTIONS);
            return (B)((Builder)this.uItems(items));
        }

        public B exceptions(Collection<String> items) {
            return this.exceptions((String[])items.toArray(String[]::new));
        }

        public B relatedTo(String ... items) {
            this.section(RuleDescription.SECTION_RELATED_TO);
            return (B)((Builder)this.uItems(items));
        }

        public B relatedTo(Collection<String> items) {
            return this.relatedTo((String[])items.toArray(String[]::new));
        }

        @Override
        public RuleDescription build() {
            return new RuleDescription(this);
        }
    }
}

