/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.IssueId;
import cdc.issues.IssueSeverity;
import cdc.issues.IssueSeverityItem;
import cdc.issues.Params;
import cdc.issues.locations.Location;
import cdc.issues.rules.RuleId;
import cdc.util.lang.Checks;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class Issue {
    public static final Comparator<Issue> TIMESTAMP_COMPARATOR = Comparator.comparing(Issue::getTimestamp);
    private final Instant timestamp;
    private final IssueId id;
    private final IssueSeverity severity;
    private final String description;

    protected Issue(Instant timestamp, String domain, String name, Params params, List<? extends Location> locations, IssueSeverity severity, String description) {
        this.timestamp = timestamp == null ? Instant.now() : timestamp;
        this.id = new IssueId(domain, name, params, locations.toArray(new Location[locations.size()]));
        this.severity = (IssueSeverity)((Object)Checks.isNotNull((Object)((Object)severity), (String)"severity"));
        this.description = (String)Checks.isNotNull((Object)description, (String)"description");
    }

    protected Issue(String domain, String name, Params params, List<? extends Location> locations, IssueSeverity severity, String description) {
        this(null, domain, name, params, locations, severity, description);
    }

    protected Issue(Instant timestamp, String domain, Enum<?> name, Params params, List<? extends Location> locations, IssueSeverity severity, String description) {
        this(timestamp, domain, name.name(), params, locations, severity, description);
    }

    protected Issue(String domain, Enum<?> name, Params params, List<? extends Location> locations, IssueSeverity severity, String description) {
        this(null, domain, name, params, locations, severity, description);
    }

    public final Instant getTimestamp() {
        return this.timestamp;
    }

    public IssueId getId() {
        return this.id;
    }

    public RuleId getRuleId() {
        return this.id.getRuleId();
    }

    public String getDomain() {
        return this.id.getDomain();
    }

    public String getName() {
        return this.id.getName();
    }

    public <T extends Enum<T>> T getName(Class<T> typeClass) {
        return this.id.getName(typeClass);
    }

    public Params getParams() {
        return this.id.getParams();
    }

    public final IssueSeverity getSeverity() {
        return this.severity;
    }

    public final String getDescription() {
        return this.description;
    }

    public Location[] getLocations() {
        return this.id.getLocations();
    }

    public final int getNumberOfLocations() {
        return this.id.getLocations().length;
    }

    public Location getLocationAt(int index) {
        return this.id.getLocations()[index];
    }

    public <L extends Location> L getLocationAt(int index, Class<L> cls) {
        return (L)((Location)cls.cast(this.getLocationAt(index)));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.id, this.severity, this.description});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Issue)) {
            return false;
        }
        Issue other = (Issue)object;
        return Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.id, other.id) && this.severity == other.severity && Objects.equals(this.description, other.description);
    }

    public String toString() {
        return this.getTimestamp() + " - " + this.getDomain() + " - " + this.getName() + " - " + (Object)((Object)this.getSeverity()) + " - " + this.getDescription() + " - " + Arrays.toString(this.getLocations());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static abstract class AbstractIssueBuilder<B extends AbstractIssueBuilder<B, I>, I extends Issue>
    extends Builder {
        protected AbstractIssueBuilder() {
        }

        protected abstract B self();

        @Override
        public Builder timestamp(Instant timestamp) {
            super.timestamp(timestamp);
            return this.self();
        }

        public B ruleId(RuleId ruleId) {
            super.ruleId(ruleId);
            return (B)this.self();
        }

        public B domain(String domain) {
            super.domain(domain);
            return (B)this.self();
        }

        public B name(String name) {
            super.name(name);
            return (B)this.self();
        }

        public B name(Enum<?> name) {
            super.name(name);
            return (B)this.self();
        }

        public B params(Params params) {
            super.params(params);
            return (B)this.self();
        }

        public B addLocation(Location location) {
            super.addLocation(location);
            return (B)this.self();
        }

        public B locations(Location ... locations) {
            super.locations(locations);
            return (B)this.self();
        }

        public B locations(List<Location> locations) {
            super.locations(locations);
            return (B)this.self();
        }

        public B severity(IssueSeverity severity) {
            super.severity(severity);
            return (B)this.self();
        }

        public B description(String description) {
            super.description(description);
            return (B)this.self();
        }

        public abstract I build();
    }

    public static class Builder {
        protected Instant timestamp = null;
        protected String domain;
        protected String name;
        protected Params params = Params.NO_PARAMS;
        protected IssueSeverity severity;
        protected String description;
        protected final List<Location> locations = new ArrayList<Location>();

        protected Builder() {
        }

        protected Builder self() {
            return this;
        }

        public Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this.self();
        }

        public Builder ruleId(RuleId ruleId) {
            this.domain = ruleId.getDomain();
            this.name = ruleId.getName();
            return this.self();
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public Builder name(String name) {
            this.name = name;
            return this.self();
        }

        public Builder name(Enum<?> name) {
            this.name = name.name();
            if (this.severity == null && name instanceof IssueSeverityItem) {
                this.severity(((IssueSeverityItem)((Object)name)).getSeverity());
            }
            return this.self();
        }

        public Builder params(Params params) {
            this.params = params;
            return this.self();
        }

        public Builder addLocation(Location location) {
            this.locations.add(location);
            return this.self();
        }

        public Builder locations(Location ... locations) {
            this.locations.clear();
            Collections.addAll(this.locations, locations);
            return this;
        }

        public Builder locations(List<Location> locations) {
            this.locations.clear();
            this.locations.addAll(locations);
            return this;
        }

        public Builder severity(IssueSeverity severity) {
            this.severity = severity;
            return this.self();
        }

        public Builder description(String description) {
            this.description = description;
            return this.self();
        }

        public Issue build() {
            return new Issue(this.timestamp, this.domain, this.name, this.params, this.locations, this.severity, this.description);
        }
    }
}

