/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class Params {
    public static final Params NO_PARAMS = Params.builder().build();
    private final Map<String, String> map = new HashMap<String, String>();

    private Params(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<String> getNames() {
        return this.map.keySet();
    }

    public List<String> getSortedNames() {
        return this.map.keySet().stream().sorted().collect(Collectors.toList());
    }

    public String getValue(String name) {
        return this.map.get(name);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Params)) {
            return false;
        }
        Params other = (Params)object;
        return this.map.equals(other.map);
    }

    public String toString() {
        return this.getSortedNames().stream().map(name -> name + ":" + this.getValue((String)name)).collect(Collectors.joining(" ", "[", "]"));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, String> map = new HashMap<String, String>();

        private Builder() {
        }

        public Builder param(String name, String value) {
            this.map.put(name, value);
            return this;
        }

        public Params build() {
            return new Params(this.map);
        }
    }
}

