/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.rules;

import cdc.issues.rules.IssuesDetector;
import cdc.issues.rules.Rule;
import cdc.issues.rules.RulesCatalog;
import cdc.util.lang.Checks;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class CompositeRulesCatalog
implements RulesCatalog {
    private final Set<RulesCatalog> catalogs = new LinkedHashSet<RulesCatalog>();

    public CompositeRulesCatalog add(RulesCatalog catalog) {
        Checks.isNotNull((Object)catalog, (String)"catalog");
        this.catalogs.add(catalog);
        return this;
    }

    @Override
    public Set<String> getDomains() {
        HashSet<String> set = new HashSet<String>();
        for (RulesCatalog catalog : this.catalogs) {
            set.addAll(catalog.getDomains());
        }
        return set;
    }

    @Override
    public Set<Rule> getRules() {
        HashSet<Rule> set = new HashSet<Rule>();
        for (RulesCatalog catalog : this.catalogs) {
            set.addAll(catalog.getRules());
        }
        return set;
    }

    @Override
    public Set<IssuesDetector.Descriptor<?>> getDescriptors() {
        HashSet set = new HashSet();
        for (RulesCatalog catalog : this.catalogs) {
            set.addAll(catalog.getDescriptors());
        }
        return set;
    }

    @Override
    public <T> Set<IssuesDetector.Descriptor<T>> getDescriptors(Class<T> dataClass) {
        HashSet<IssuesDetector.Descriptor<T>> set = new HashSet<IssuesDetector.Descriptor<T>>();
        for (RulesCatalog catalog : this.catalogs) {
            set.addAll(catalog.getDescriptors(dataClass));
        }
        return set;
    }

    @Override
    public <T> IssuesDetector.Descriptor<T> getDescriptorOrNull(Rule rule, Class<T> dataClass) {
        for (RulesCatalog catalog : this.catalogs) {
            IssuesDetector.Descriptor<T> descriptor = catalog.getDescriptorOrNull(rule, dataClass);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }
}

