/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.rules;

import cdc.issues.FormalParams;
import cdc.issues.Issue;
import cdc.issues.IssuesHandler;
import cdc.issues.Params;
import cdc.issues.locations.Location;
import cdc.issues.rules.Rule;
import cdc.util.lang.CollectionUtils;
import java.util.Collections;
import java.util.Set;

public interface IssuesDetector<T> {
    public Descriptor<T> getDescriptor();

    default public Class<T> getDataClass() {
        return this.getDescriptor().getDataClass();
    }

    public Set<Rule> getEnabledRules();

    public Params getParams();

    public void analyze(T var1, Location var2, IssuesHandler<Issue> var3);

    public static String toString(IssuesDetector<?> detector) {
        StringBuilder builder = new StringBuilder();
        builder.append("IssuesDetector<").append(detector.getDataClass().getSimpleName()).append(">(");
        boolean first = true;
        for (Rule rule : detector.getEnabledRules()) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(rule.getName());
        }
        builder.append(")");
        return builder.toString();
    }

    public static abstract class AbstractDescriptor<T>
    implements Descriptor<T> {
        private final Class<T> dataClass;
        private final FormalParams formalParams;
        private final Set<Rule> rules;

        protected AbstractDescriptor(Class<T> dataClass, FormalParams formalParams, Rule ... rules) {
            this.dataClass = dataClass;
            this.formalParams = formalParams;
            this.rules = Collections.unmodifiableSet(CollectionUtils.toSet((Object[])rules));
        }

        protected AbstractDescriptor(Class<T> dataClass, Rule ... rules) {
            this(dataClass, FormalParams.NO_PARAMS, rules);
        }

        @Override
        public final Class<T> getDataClass() {
            return this.dataClass;
        }

        @Override
        public final Set<Rule> getRules() {
            return this.rules;
        }

        @Override
        public final FormalParams getFormalParams() {
            return this.formalParams;
        }
    }

    public static interface Descriptor<T> {
        public Class<T> getDataClass();

        public Set<Rule> getRules();

        public FormalParams getFormalParams();

        public IssuesDetector<T> create(Params var1, Set<Rule> var2);
    }
}

