/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.impl;

import cdc.issues.Issue;
import cdc.issues.IssueSeverity;
import cdc.issues.IssuesCollector;
import cdc.issues.IssuesHandler;
import cdc.issues.VerboseIssuesHandler;
import cdc.issues.impl.ProfileImpl;
import cdc.issues.impl.RulesCatalogImpl;
import cdc.issues.locations.DefaultLocatedData;
import cdc.issues.locations.DefaultLocation;
import cdc.issues.locations.Location;
import cdc.issues.rules.AbstractIssueDetector;
import cdc.issues.rules.CompositeRulesCatalog;
import cdc.issues.rules.ConfiguredRule;
import cdc.issues.rules.DataSource;
import cdc.issues.rules.IssuesDetector;
import cdc.issues.rules.Profile;
import cdc.issues.rules.Rule;
import cdc.issues.rules.RulesCatalog;
import cdc.util.events.ProgressController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RulesCatalogImplTest {
    private static final Logger LOGGER = LogManager.getLogger(RulesCatalogImplTest.class);
    static final String PROJECT = "project";
    static final String SNAPSHOT = "snapshot";
    static final Rule RULE1 = Rule.builder().domain("Domain").name("Rule1").addSeverity(IssueSeverity.CRITICAL).description("Rule 1 description").build();
    static final Rule RULE2 = Rule.builder().domain("Domain").name("Rule2").addSeverity(IssueSeverity.CRITICAL).description("Rule 2 description").build();
    static final Rule RULE3 = Rule.builder().domain("Domain").name("Rule3").addSeverity(IssueSeverity.CRITICAL).description("Rule 3 description").build();
    static final IssuesDetector.Descriptor<String> DESCRIPTOR12 = new IssuesDetector.AbstractDescriptor<String>(String.class, new Rule[]{RULE1, RULE2}){

        public IssuesDetector<String> create(String project, String snapshot, Set<ConfiguredRule> configuredRules) {
            return new Detector1(project, snapshot, configuredRules);
        }
    };

    RulesCatalogImplTest() {
    }

    @Test
    void test() {
        RulesCatalogImpl catalog1 = new RulesCatalogImpl().register(RULE1).register(RULE2).register(RULE3).register(DESCRIPTOR12);
        ProfileImpl profile1 = new ProfileImpl("profile").enableRule(RULE1).enableRule(RULE2).enableRule(RULE3);
        CompositeRulesCatalog ccatalog = new CompositeRulesCatalog().add((RulesCatalog)catalog1);
        Assertions.assertEquals((int)1, (int)catalog1.getDomains().size());
        Assertions.assertEquals((int)3, (int)catalog1.getRules().size());
        Assertions.assertEquals((int)3, (int)catalog1.getRules("Domain").size());
        Assertions.assertEquals((int)0, (int)catalog1.getRules("domain").size());
        Assertions.assertEquals((int)1, (int)catalog1.getDescriptors().size());
        Assertions.assertEquals((int)1, (int)catalog1.getDescriptors(String.class).size());
        Assertions.assertTrue((boolean)catalog1.hasDescriptor(RULE1, String.class));
        Assertions.assertTrue((boolean)catalog1.hasDescriptor(RULE2, String.class));
        Assertions.assertFalse((boolean)catalog1.hasDescriptor(RULE3, String.class));
        Assertions.assertTrue((boolean)catalog1.hasDomain("Domain"));
        Assertions.assertFalse((boolean)catalog1.hasDomain("domain"));
        Assertions.assertTrue((boolean)catalog1.hasRule(RULE1));
        Assertions.assertEquals(String.class, (Object)DESCRIPTOR12.getDataClass());
        IssuesDetector detector1 = catalog1.createIssuesDetector(null, null, new ConfiguredRule(RULE1), String.class);
        Assertions.assertEquals(String.class, (Object)detector1.getDataClass());
        Assertions.assertSame(DESCRIPTOR12, (Object)detector1.getDescriptor());
        Assertions.assertEquals((int)1, (int)detector1.getEnabledConfiguredRules().size());
        Assertions.assertTrue((boolean)detector1.getEnabledRules().contains(RULE1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RulesCatalogImplTest.lambda$test$0((RulesCatalog)catalog1));
        Assertions.assertEquals((int)1, (int)ccatalog.getDomains().size());
        Assertions.assertEquals((int)3, (int)ccatalog.getRules().size());
        Assertions.assertEquals((int)3, (int)ccatalog.getRules("Domain").size());
        Assertions.assertEquals((int)0, (int)ccatalog.getRules("domain").size());
        Assertions.assertEquals((int)1, (int)ccatalog.getDescriptors().size());
        Assertions.assertEquals((int)1, (int)ccatalog.getDescriptors(String.class).size());
        Assertions.assertTrue((boolean)ccatalog.hasDescriptor(RULE1, String.class));
        Assertions.assertTrue((boolean)ccatalog.hasDescriptor(RULE2, String.class));
        Assertions.assertFalse((boolean)ccatalog.hasDescriptor(RULE3, String.class));
        detector1.toString();
        IssuesDetector detector12 = catalog1.getDescriptor(RULE1, String.class).create(PROJECT, SNAPSHOT, new ConfiguredRule[]{new ConfiguredRule(RULE1), new ConfiguredRule(RULE2)});
        detector12.toString();
        Assertions.assertThrows(IllegalArgumentException.class, () -> DESCRIPTOR12.create(PROJECT, SNAPSHOT, new ConfiguredRule(RULE3)));
        IssuesCollector collector = new IssuesCollector();
        Assertions.assertSame((Object)IssuesHandler.VOID, (Object)collector.getDelegate());
        DefaultLocation location = new DefaultLocation("Test");
        detector1.analyze((Object)"Hello", (Location)location, (IssuesHandler)collector);
        Assertions.assertEquals((int)1, (int)collector.getIssues().size());
        Assertions.assertEquals((int)1, (int)collector.getIssues(IssueSeverity.INFO).size());
        collector.clear();
        ArrayList data = new ArrayList();
        Collections.addAll(data, new DefaultLocatedData((Object)"Hello", (Location)location), new DefaultLocatedData((Object)"World", (Location)location));
        catalog1.apply(PROJECT, SNAPSHOT, (Profile)profile1, new DataSource(String.class, data.spliterator()), (IssuesHandler)new VerboseIssuesHandler((IssuesHandler)collector), ProgressController.VERBOSE);
        Assertions.assertEquals((int)4, (int)collector.getIssues().size());
    }

    private static /* synthetic */ void lambda$test$0(RulesCatalog catalog1) throws Throwable {
        catalog1.createIssuesDetector(null, null, new ConfiguredRule(RULE3), String.class);
    }

    static class Detector1
    extends AbstractIssueDetector<String> {
        Detector1(String project, String snapshot, Set<ConfiguredRule> configuredRules) {
            super(DESCRIPTOR12, project, snapshot, configuredRules);
        }

        public void analyze(String data, List<Location> locations, IssuesHandler<Issue> issuesHandler) {
            LOGGER.info("analyze({}, {})", (Object)data, locations);
            for (ConfiguredRule crule : this.getEnabledConfiguredRules()) {
                issuesHandler.issue(Issue.builder().domain(crule.getRule().getDomain()).name(crule.getRule().getName()).description("Analyzed " + data).severity(IssueSeverity.INFO).locations(locations).build());
            }
        }
    }
}

