/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.impl;

import cdc.issues.Issue;
import cdc.issues.IssueId;
import cdc.issues.answers.IssueAnswer;
import cdc.issues.answers.IssuesAndAnswers;
import cdc.issues.impl.IssueAnswerImpl;
import cdc.util.lang.Checks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class IssuesAndAnswersImpl
implements IssuesAndAnswers {
    private final List<Issue> issues = new ArrayList<Issue>();
    private final Map<IssueId, IssueAnswer> map = new HashMap<IssueId, IssueAnswer>();
    private final Set<IssueAnswerImpl> answers = new HashSet<IssueAnswerImpl>();

    public IssuesAndAnswersImpl addIssue(Issue issue) {
        Checks.isNotNull((Object)issue, (String)"issue");
        this.issues.add(issue);
        return this;
    }

    public IssuesAndAnswersImpl addIssues(List<? extends Issue> issues) {
        this.issues.addAll(issues);
        return this;
    }

    public IssuesAndAnswersImpl addAnswer(IssueAnswerImpl answer) {
        Checks.isNotNull((Object)answer, (String)"answer");
        IssueAnswer current = this.map.get(answer.getIssueId());
        this.answers.remove(current);
        this.answers.add(answer);
        this.map.put(answer.getIssueId(), answer);
        return this;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public Set<IssueAnswerImpl> getAnswers() {
        return this.answers;
    }

    public IssueAnswer getAnswer(IssueId id) {
        return this.map.get(id);
    }

    public int hashCode() {
        return Objects.hash(this.issues, this.answers);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IssuesAndAnswersImpl)) {
            return false;
        }
        IssuesAndAnswersImpl other = (IssuesAndAnswersImpl)object;
        return Objects.equals(this.issues, other.issues) && Objects.equals(this.answers, other.answers);
    }
}

