/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.impl;

import cdc.issues.IssueId;
import cdc.issues.Project;
import cdc.issues.answers.IssueAnswer;
import cdc.issues.impl.IssueAnswerImpl;
import cdc.issues.impl.ProfileImpl;
import cdc.issues.impl.SnapshotImpl;
import cdc.issues.rules.DataSource;
import cdc.util.lang.Checks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProjectImpl
implements Project {
    private String name;
    private ProfileImpl profile;
    private final List<SnapshotImpl> snapshots = new ArrayList<SnapshotImpl>();
    private final Map<IssueId, IssueAnswerImpl> map = new HashMap<IssueId, IssueAnswerImpl>();
    private final Set<IssueAnswerImpl> answers = new HashSet<IssueAnswerImpl>();
    private final List<DataSource<?>> dataSources = new ArrayList();

    public ProjectImpl(String name) {
        this.name = name;
    }

    public ProjectImpl setName(String name) {
        this.name = name;
        return this;
    }

    public ProjectImpl setProfile(ProfileImpl profile) {
        Checks.isNotNull((Object)profile, (String)"profile");
        this.profile = profile;
        return this;
    }

    public ProjectImpl addSnapshot(SnapshotImpl snapshot) {
        Checks.isNotNull((Object)snapshot, (String)"snapshot");
        this.snapshots.add(snapshot);
        return this;
    }

    public ProjectImpl addAnswer(IssueAnswerImpl answer) {
        Checks.isNotNull((Object)answer, (String)"answer");
        IssueAnswer current = this.map.get(answer.getIssueId());
        this.answers.remove(current);
        this.answers.add(answer);
        this.map.put(answer.getIssueId(), answer);
        return this;
    }

    public ProjectImpl addAnswers(Collection<IssueAnswerImpl> answers) {
        for (IssueAnswerImpl answer : answers) {
            this.addAnswer(answer);
        }
        return this;
    }

    public ProjectImpl addDataSource(DataSource<?> dataSource) {
        Checks.isNotNull(dataSource, (String)"dataSource");
        this.dataSources.add(dataSource);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ProfileImpl getProfile() {
        return this.profile;
    }

    public Iterable<DataSource<?>> getDataSources() {
        return this.dataSources;
    }

    public List<SnapshotImpl> getSnapshots() {
        return this.snapshots;
    }

    public Set<IssueAnswerImpl> getAnswers() {
        return this.answers;
    }

    public IssueAnswerImpl getAnswer(IssueId id) {
        return this.map.get(id);
    }
}

