/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.impl;

import cdc.issues.rules.IssuesDetector;
import cdc.issues.rules.Rule;
import cdc.issues.rules.RulesCatalog;
import cdc.tuples.Tuple2;
import cdc.util.lang.Checks;
import cdc.util.lang.Introspection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RulesCatalogImpl
implements RulesCatalog {
    private final Map<String, Set<Rule>> domainToRules = new HashMap<String, Set<Rule>>();
    private final Set<Rule> rules = new HashSet<Rule>();
    private final Set<IssuesDetector.Descriptor<?>> descriptors = new HashSet();
    private final Map<Tuple2<Rule, Class<?>>, IssuesDetector.Descriptor<?>> ruleDataClassToDescriptor = new HashMap();
    private final Map<Class<?>, Set<IssuesDetector.Descriptor<?>>> dataClassToDescriptors = new HashMap();

    public RulesCatalogImpl register(Rule rule) {
        Checks.isNotNull((Object)rule, (String)"rule");
        Checks.doesNotContain(this.rules, (Object)rule, (String)"rules");
        this.rules.add(rule);
        Set set = this.domainToRules.computeIfAbsent(rule.getId().getDomain(), k -> new HashSet());
        set.add(rule);
        return this;
    }

    public <T> RulesCatalogImpl register(IssuesDetector.Descriptor<T> descriptor) {
        Checks.isNotNull(descriptor, (String)"descriptor");
        Checks.doesNotContain(this.descriptors, descriptor, (String)"descriptors");
        this.descriptors.add(descriptor);
        Set set = this.dataClassToDescriptors.computeIfAbsent(descriptor.getDataClass(), k -> new HashSet());
        set.add(descriptor);
        for (Rule rule : descriptor.getSupportedRules()) {
            Tuple2 key = new Tuple2((Object)rule, (Object)descriptor.getDataClass());
            if (!this.hasRule(rule)) {
                this.register(rule);
            }
            if (this.ruleDataClassToDescriptor.containsKey(key)) {
                throw new IllegalArgumentException("Duplicate descriptor for " + key);
            }
            this.ruleDataClassToDescriptor.put(key, descriptor);
        }
        return this;
    }

    public Set<String> getDomains() {
        return this.domainToRules.keySet();
    }

    public Set<Rule> getRules() {
        return this.rules;
    }

    public Set<Rule> getRules(String domain) {
        return this.domainToRules.getOrDefault(domain, Collections.emptySet());
    }

    public Set<IssuesDetector.Descriptor<?>> getDescriptors() {
        return this.descriptors;
    }

    public <T> Set<IssuesDetector.Descriptor<T>> getDescriptors(Class<T> dataClass) {
        Set set = this.dataClassToDescriptors.getOrDefault(dataClass, Collections.emptySet());
        return (Set)Introspection.uncheckedCast(set);
    }

    public <T> IssuesDetector.Descriptor<T> getDescriptorOrNull(Rule rule, Class<T> dataClass) {
        Tuple2 key = new Tuple2((Object)rule, dataClass);
        return (IssuesDetector.Descriptor)Introspection.uncheckedCast(this.ruleDataClassToDescriptor.get(key));
    }
}

