/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.impl;

import cdc.issues.Issue;
import cdc.issues.Snapshot;
import cdc.util.lang.Checks;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class SnapshotImpl
implements Snapshot {
    private String name;
    private Instant timestamp;
    private final List<Issue> issues = new ArrayList<Issue>();

    public SnapshotImpl() {
        this(null);
    }

    public SnapshotImpl(String name) {
        this(name, Instant.now());
    }

    public SnapshotImpl(String name, Instant timestamp) {
        this.name = name;
        this.timestamp = timestamp;
    }

    public SnapshotImpl setName(String name) {
        this.name = name;
        return this;
    }

    public SnapshotImpl setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public SnapshotImpl addIssue(Issue issue) {
        Checks.isNotNull((Object)issue, (String)"issue");
        this.issues.add(issue);
        return this;
    }

    public SnapshotImpl addIssues(List<? extends Issue> issues) {
        this.issues.addAll(issues);
        return this;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getName() {
        return this.name;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }
}

