/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.impl;

import cdc.issues.Params;
import cdc.issues.rules.ConfiguredRule;
import cdc.issues.rules.Profile;
import cdc.issues.rules.Rule;
import cdc.util.lang.Checks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ProfileImpl
implements Profile {
    private String name;
    private Params metas = Params.NO_PARAMS;
    private final Set<Rule> enabledRules = new HashSet<Rule>();
    private final Map<Rule, Params> rules = new HashMap<Rule, Params>();

    public ProfileImpl(String name) {
        this.name = name;
    }

    public ProfileImpl setName(String name) {
        this.name = name;
        return this;
    }

    public ProfileImpl setMetas(Params metas) {
        this.metas = metas;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Params getMetas() {
        return this.metas;
    }

    public ProfileImpl add(Rule rule, Params params) {
        Checks.isNotNull((Object)rule, (String)"rule");
        Checks.isNotNull((Object)params, (String)"params");
        this.enabledRules.add(rule);
        this.rules.put(rule, params);
        return this;
    }

    public ProfileImpl add(Rule rule) {
        return this.add(rule, Params.NO_PARAMS);
    }

    public ProfileImpl remove(Rule rule) {
        this.rules.remove(rule);
        this.enabledRules.remove(rule);
        return this;
    }

    public ProfileImpl setEnabled(Rule rule, boolean enabled) {
        Checks.isNotNull((Object)rule, (String)"rule");
        if (enabled) {
            this.rules.putIfAbsent(rule, Params.NO_PARAMS);
            this.enabledRules.add(rule);
        } else {
            this.enabledRules.remove(rule);
        }
        return this;
    }

    public Set<Rule> getRules() {
        return this.rules.keySet();
    }

    public Set<ConfiguredRule> getConfiguredRules() {
        HashSet<ConfiguredRule> set = new HashSet<ConfiguredRule>();
        for (Map.Entry<Rule, Params> entry : this.rules.entrySet()) {
            set.add(new ConfiguredRule(entry.getKey(), entry.getValue()));
        }
        return set;
    }

    public Set<Rule> getEnabledRules() {
        return this.enabledRules;
    }

    public Set<ConfiguredRule> getEnabledConfiguredRules() {
        HashSet<ConfiguredRule> set = new HashSet<ConfiguredRule>();
        for (Map.Entry<Rule, Params> entry : this.rules.entrySet()) {
            if (!this.isEnabled(entry.getKey())) continue;
            set.add(new ConfiguredRule(entry.getKey(), entry.getValue()));
        }
        return set;
    }

    public boolean isEnabled(Rule rule) {
        Checks.isNotNull((Object)rule, (String)"rule");
        return this.enabledRules.contains(rule);
    }

    public Params getParams(Rule rule) {
        Checks.isNotNull((Object)rule, (String)"rule");
        return this.rules.get(rule);
    }
}

