/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.impl;

import cdc.issues.rules.IssuesDetector;
import cdc.issues.rules.Rule;
import cdc.issues.rules.RuleId;
import cdc.issues.rules.RulesCatalog;
import cdc.tuples.Tuple2;
import cdc.util.lang.Checks;
import cdc.util.lang.Introspection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class RulesCatalogImpl
implements RulesCatalog {
    private final Map<String, Set<Rule>> domainToRules = new HashMap<String, Set<Rule>>();
    private final Set<Rule> rules = new HashSet<Rule>();
    private final Map<RuleId, Rule> idToRules = new HashMap<RuleId, Rule>();
    private final Set<IssuesDetector.Factory<?>> factories = new HashSet();
    private final Map<Tuple2<Rule, Class<?>>, IssuesDetector.Factory<?>> ruleDataClassToFactory = new HashMap();
    private final Map<Class<?>, Set<IssuesDetector.Factory<?>>> dataClassToFactories = new HashMap();

    public RulesCatalogImpl register(Rule rule) {
        Checks.isNotNull((Object)rule, (String)"rule");
        Checks.doesNotContain(this.rules, (Object)rule, (String)"rules");
        Checks.doesNotContainKey(this.idToRules, (Object)rule.getId(), (String)"idToRules");
        this.rules.add(rule);
        this.idToRules.put(rule.getId(), rule);
        Set set = this.domainToRules.computeIfAbsent(rule.getId().getDomain(), k -> new HashSet());
        set.add(rule);
        return this;
    }

    public <T> RulesCatalogImpl register(IssuesDetector.Factory<T> factory) {
        Checks.isNotNull(factory, (String)"factory");
        Checks.doesNotContain(this.factories, factory, (String)"factory");
        this.factories.add(factory);
        Set set = this.dataClassToFactories.computeIfAbsent(factory.getDataClass(), k -> new HashSet());
        set.add(factory);
        for (Rule rule : factory.getSupportedRules()) {
            Tuple2 key = new Tuple2((Object)rule, (Object)factory.getDataClass());
            if (!this.hasRule(rule)) {
                this.register(rule);
            }
            if (this.ruleDataClassToFactory.containsKey(key)) {
                throw new IllegalArgumentException("Duplicate factory for " + key);
            }
            this.ruleDataClassToFactory.put(key, factory);
        }
        return this;
    }

    public Set<String> getDomains() {
        return this.domainToRules.keySet();
    }

    public Set<Rule> getRules() {
        return this.rules;
    }

    public Set<Rule> getRules(String domain) {
        return this.domainToRules.getOrDefault(domain, Collections.emptySet());
    }

    public Optional<Rule> getRule(RuleId id) {
        return Optional.ofNullable(this.idToRules.get(id));
    }

    public Set<IssuesDetector.Factory<?>> getFactories() {
        return this.factories;
    }

    public <T> Set<IssuesDetector.Factory<T>> getFactories(Class<T> dataClass) {
        Set set = this.dataClassToFactories.getOrDefault(dataClass, Collections.emptySet());
        return (Set)Introspection.uncheckedCast(set);
    }

    public <T> Optional<IssuesDetector.Factory<T>> getFactory(Rule rule, Class<T> dataClass) {
        Tuple2 key = new Tuple2((Object)rule, dataClass);
        IssuesDetector.Factory value = (IssuesDetector.Factory)Introspection.uncheckedCast(this.ruleDataClassToFactory.get(key));
        return Optional.ofNullable(value);
    }
}

