/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.impl;

import cdc.issues.Params;
import cdc.issues.rules.ConfiguredRule;
import cdc.issues.rules.Profile;
import cdc.issues.rules.Rule;
import cdc.util.lang.Checks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ProfileImpl
implements Profile {
    private static final String METAS = "metas";
    private static final String PARAMS = "params";
    private static final String RULE = "rule";
    private String name;
    private Params metas = Params.NO_PARAMS;
    private final Set<Rule> enabledRules = new HashSet<Rule>();
    private final Map<Rule, Params> ruleToParams = new HashMap<Rule, Params>();

    public ProfileImpl(String name) {
        this.name = name;
    }

    public ProfileImpl setName(String name) {
        this.name = name;
        return this;
    }

    public ProfileImpl setMetas(Params metas) {
        this.metas = (Params)Checks.isNotNull((Object)metas, (String)METAS);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Params getMetas() {
        return this.metas;
    }

    public ProfileImpl add(Rule rule, Params params) {
        Checks.isNotNull((Object)rule, (String)RULE);
        Checks.isNotNull((Object)params, (String)PARAMS);
        this.enabledRules.add(rule);
        this.ruleToParams.put(rule, params);
        return this;
    }

    public ProfileImpl add(Rule rule) {
        return this.add(rule, Params.NO_PARAMS);
    }

    public ProfileImpl remove(Rule rule) {
        this.ruleToParams.remove(rule);
        this.enabledRules.remove(rule);
        return this;
    }

    public ProfileImpl setEnabled(Rule rule, boolean enabled) {
        Checks.isNotNull((Object)rule, (String)RULE);
        if (enabled) {
            this.ruleToParams.putIfAbsent(rule, Params.NO_PARAMS);
            this.enabledRules.add(rule);
        } else {
            this.enabledRules.remove(rule);
        }
        return this;
    }

    public Set<Rule> getRules() {
        return this.ruleToParams.keySet();
    }

    public Set<ConfiguredRule> getConfiguredRules() {
        HashSet<ConfiguredRule> set = new HashSet<ConfiguredRule>();
        for (Map.Entry<Rule, Params> entry : this.ruleToParams.entrySet()) {
            set.add(new ConfiguredRule(entry.getKey(), entry.getValue()));
        }
        return set;
    }

    public Set<Rule> getEnabledRules() {
        return this.enabledRules;
    }

    public Set<ConfiguredRule> getEnabledConfiguredRules() {
        HashSet<ConfiguredRule> set = new HashSet<ConfiguredRule>();
        for (Map.Entry<Rule, Params> entry : this.ruleToParams.entrySet()) {
            if (!this.isEnabled(entry.getKey())) continue;
            set.add(new ConfiguredRule(entry.getKey(), entry.getValue()));
        }
        return set;
    }

    public boolean isEnabled(Rule rule) {
        Checks.isNotNull((Object)rule, (String)RULE);
        return this.enabledRules.contains(rule);
    }

    public Params getParams(Rule rule) {
        Checks.isNotNull((Object)rule, (String)RULE);
        return this.ruleToParams.get(rule);
    }
}

