/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.impl;

import cdc.issues.Params;
import cdc.issues.Project;
import cdc.issues.Snapshot;
import cdc.issues.io.SnapshotData;
import cdc.issues.rules.Profile;
import java.time.Instant;
import java.util.Optional;

public class SnapshotDataImpl
implements SnapshotData {
    private String projectName;
    private Params projectMetas = Params.NO_PARAMS;
    private Profile profile;
    private String snapshotName;
    private Params snapshotMetas = Params.NO_PARAMS;
    private Instant snapshotTimestamp = Instant.now();
    private int numberOfIssues = -1;

    public SnapshotDataImpl() {
    }

    public SnapshotDataImpl(Snapshot snapshot) {
        Project project = snapshot.getProject().orElse(null);
        this.setProjectName(project == null ? null : project.getName());
        this.setProjectMetas(project == null ? Params.NO_PARAMS : project.getMetas());
        this.setProfile(project == null ? null : (Profile)project.getProfile().orElse(null));
        this.setSnapshotName(snapshot.getName());
        this.setSnapshotMetas(snapshot.getMetas());
        this.setSnapshotTimestamp(snapshot.getTimestamp());
    }

    public SnapshotDataImpl setProjectName(String name) {
        this.projectName = name;
        return this;
    }

    public SnapshotDataImpl setProjectMetas(Params metas) {
        this.projectMetas = metas;
        return this;
    }

    public SnapshotDataImpl setProfile(Profile profile) {
        this.profile = profile;
        return this;
    }

    public SnapshotDataImpl setSnapshotName(String name) {
        this.snapshotName = name;
        return this;
    }

    public SnapshotDataImpl setSnapshotMetas(Params metas) {
        this.snapshotMetas = metas;
        return this;
    }

    public SnapshotDataImpl setSnapshotTimestamp(Instant timestamp) {
        this.snapshotTimestamp = timestamp;
        return this;
    }

    public SnapshotDataImpl setNumberOfIssues(int number) {
        this.numberOfIssues = number;
        return this;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Params getProjectMetas() {
        return this.projectMetas;
    }

    public Optional<? extends Profile> getProfile() {
        return Optional.ofNullable(this.profile);
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public Params getSnapshotMetas() {
        return this.snapshotMetas;
    }

    public Instant getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    public int getNumberOfIssues() {
        return this.numberOfIssues;
    }
}

