/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.impl;

import cdc.issues.IssueId;
import cdc.issues.IssueSeverity;
import cdc.issues.answers.IssueAnswer;
import cdc.issues.answers.IssueResolution;
import cdc.issues.answers.IssueStatus;
import cdc.issues.answers.IssueTransition;
import cdc.issues.impl.IssueCommentImpl;
import cdc.util.lang.Checks;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class IssueAnswerImpl
implements IssueAnswer {
    private final IssueId issueId;
    private String author;
    private final Instant creationDate;
    private Instant modificationDate;
    private IssueStatus status;
    private IssueResolution resolution;
    private String assignee;
    private IssueSeverity newSeverity;
    private final List<IssueCommentImpl> comments = new ArrayList<IssueCommentImpl>();

    protected IssueAnswerImpl(Builder builder) {
        this.issueId = (IssueId)Checks.isNotNull((Object)builder.issueId, (String)"issueId");
        this.author = builder.author;
        this.creationDate = builder.creationDate == null ? Instant.now() : builder.creationDate;
        this.modificationDate = builder.modificationDate == null ? this.creationDate : builder.modificationDate;
        this.status = (IssueStatus)Checks.isNotNull((Object)builder.status, (String)"status");
        this.resolution = (IssueResolution)Checks.isNotNull((Object)builder.resolution, (String)"resolution");
        this.assignee = builder.assignee;
        this.newSeverity = builder.newSeverity;
        this.comments.addAll(builder.comments);
    }

    public IssueId getIssueId() {
        return this.issueId;
    }

    public String getAuthor() {
        return this.author;
    }

    public IssueAnswerImpl setAuthor(String author) {
        this.author = author;
        return this;
    }

    public Instant getCreationDate() {
        return this.creationDate;
    }

    public Instant getModificationDate() {
        return this.modificationDate;
    }

    public IssueAnswerImpl setModificationDate(Instant modificationDate) {
        this.modificationDate = modificationDate;
        return this;
    }

    public IssueStatus getStatus() {
        return this.status;
    }

    public IssueAnswerImpl setStatus(IssueStatus status) {
        this.status = status;
        return this;
    }

    public IssueResolution getResolution() {
        return this.resolution;
    }

    public IssueAnswerImpl setResolution(IssueResolution resolution) {
        this.resolution = resolution;
        return this;
    }

    public IssueAnswerImpl tringger(IssueTransition transition) {
        if (transition.isValidSource(this.status, this.resolution)) {
            this.status = transition.getTargetStatus();
            this.resolution = transition.getTargetResolution();
        }
        return this;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public IssueAnswerImpl setAssignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    public IssueSeverity getNewSeverity() {
        return this.newSeverity;
    }

    public IssueAnswerImpl setNewSeverity(IssueSeverity newSeverity) {
        this.newSeverity = newSeverity;
        return this;
    }

    public List<IssueCommentImpl> getComments() {
        return this.comments;
    }

    public IssueAnswerImpl setComments(List<IssueCommentImpl> comments) {
        this.comments.clear();
        this.comments.addAll(comments);
        return this;
    }

    public IssueAnswerImpl addComment(IssueCommentImpl comment) {
        this.comments.add(comment);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.issueId, this.author, this.creationDate, this.modificationDate, this.status, this.resolution, this.assignee, this.newSeverity, this.comments);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IssueAnswerImpl)) {
            return false;
        }
        IssueAnswerImpl other = (IssueAnswerImpl)object;
        return Objects.equals(this.issueId, other.issueId) && Objects.equals(this.author, other.author) && Objects.equals(this.creationDate, other.creationDate) && Objects.equals(this.modificationDate, other.modificationDate) && Objects.equals(this.status, other.status) && Objects.equals(this.resolution, other.resolution) && Objects.equals(this.assignee, other.assignee) && Objects.equals(this.newSeverity, other.newSeverity) && Objects.equals(this.comments, other.comments);
    }

    public String toString() {
        return "[" + this.issueId + ", " + this.author + ", " + this.creationDate + ", " + this.modificationDate + ", " + this.status + ", " + this.resolution + ", " + this.assignee + ", " + this.newSeverity + ", " + this.comments + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private IssueId issueId;
        private String author;
        private Instant creationDate;
        private Instant modificationDate;
        private IssueStatus status = IssueStatus.OPEN;
        private IssueResolution resolution = IssueResolution.UNRESOLVED;
        private String assignee;
        private IssueSeverity newSeverity;
        private final List<IssueCommentImpl> comments = new ArrayList<IssueCommentImpl>();

        protected Builder() {
        }

        public Builder issueId(IssueId issueId) {
            this.issueId = issueId;
            return this;
        }

        public Builder author(String author) {
            this.author = author;
            return this;
        }

        public Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public Builder modificationDate(Instant modificationDate) {
            this.modificationDate = modificationDate;
            return this;
        }

        public Builder status(IssueStatus status) {
            this.status = status;
            return this;
        }

        public Builder resolution(IssueResolution resolution) {
            this.resolution = resolution;
            return this;
        }

        public Builder assignee(String assignee) {
            this.assignee = assignee;
            return this;
        }

        public Builder newSeverity(IssueSeverity newSeverity) {
            this.newSeverity = newSeverity;
            return this;
        }

        public Builder comment(IssueCommentImpl comment) {
            this.comments.add(comment);
            return this;
        }

        public Builder comments(List<IssueCommentImpl> comments) {
            this.comments.addAll(comments);
            return this;
        }

        public IssueAnswerImpl build() {
            return new IssueAnswerImpl(this);
        }
    }
}

