/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.impl;

import cdc.issues.IssueUtils;
import cdc.issues.Labels;
import cdc.issues.Metas;
import cdc.issues.Params;
import cdc.issues.Project;
import cdc.issues.Snapshot;
import cdc.issues.io.SnapshotData;
import cdc.issues.rules.Profile;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;

public class SnapshotDataImpl
implements SnapshotData {
    private String projectName;
    private String projectDescription;
    private Metas projectMetas = Metas.NO_METAS;
    private Labels projectLabels = Labels.NO_LABELS;
    private Profile profile;
    private String snapshotName;
    private String snapshotDescription;
    private Metas snapshotMetas = Metas.NO_METAS;
    private Labels snapshotLabels = Labels.NO_LABELS;
    private Instant snapshotTimestamp = Instant.now();
    private int numberOfIssues = -1;
    private String issuesHash = "";

    public SnapshotDataImpl() {
    }

    public SnapshotDataImpl(Snapshot snapshot) {
        Project project = snapshot.getProject().orElse(null);
        this.setProjectName(project == null ? null : project.getName());
        this.setProjectDescription(project == null ? null : project.getDescription());
        this.setProjectMetas(project == null ? Metas.NO_METAS : project.getMetas());
        this.setProfile(project == null ? null : (Profile)project.getProfile().orElse(null));
        this.setSnapshotName(snapshot.getName());
        this.setSnapshotDescription(snapshot.getDescription());
        this.setSnapshotMetas(snapshot.getMetas());
        this.setSnapshotTimestamp(snapshot.getTimestamp());
        this.setNumberOfIssues(snapshot.getIssues().size());
        this.setIssuesHash(IssueUtils.getHash((Collection)snapshot.getIssues()));
    }

    public SnapshotDataImpl setProjectName(String name) {
        this.projectName = name;
        return this;
    }

    public SnapshotDataImpl setProjectDescription(String description) {
        this.projectDescription = description;
        return this;
    }

    @Deprecated(since="2024-03-30", forRemoval=true)
    public SnapshotDataImpl setProjectMetas(Params metas) {
        return this.setProjectMetas(Metas.of((Params)metas));
    }

    public SnapshotDataImpl setProjectMetas(Metas metas) {
        this.projectMetas = metas;
        return this;
    }

    public SnapshotDataImpl setProjectLabels(Labels labels) {
        this.projectLabels = labels;
        return this;
    }

    public SnapshotDataImpl setProfile(Profile profile) {
        this.profile = profile;
        return this;
    }

    public SnapshotDataImpl setSnapshotName(String name) {
        this.snapshotName = name;
        return this;
    }

    public SnapshotDataImpl setSnapshotDescription(String description) {
        this.snapshotDescription = description;
        return this;
    }

    @Deprecated(since="2024-03-30", forRemoval=true)
    public SnapshotDataImpl setSnapshotMetas(Params metas) {
        return this.setSnapshotMetas(Metas.of((Params)metas));
    }

    public SnapshotDataImpl setSnapshotMetas(Metas metas) {
        this.snapshotMetas = metas;
        return this;
    }

    public SnapshotDataImpl setSnapshotLabels(Labels labels) {
        this.snapshotLabels = labels;
        return this;
    }

    public SnapshotDataImpl setSnapshotTimestamp(Instant timestamp) {
        this.snapshotTimestamp = timestamp;
        return this;
    }

    public SnapshotDataImpl setNumberOfIssues(int number) {
        this.numberOfIssues = number;
        return this;
    }

    public SnapshotDataImpl setIssuesHash(String hash) {
        this.issuesHash = hash;
        return this;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public Metas getProjectMetas() {
        return this.projectMetas;
    }

    public Labels getProjectLabels() {
        return this.projectLabels;
    }

    public Optional<? extends Profile> getProfile() {
        return Optional.ofNullable(this.profile);
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public String getSnapshotDescription() {
        return this.snapshotDescription;
    }

    public Metas getSnapshotMetas() {
        return this.snapshotMetas;
    }

    public Labels getSnapshotLabels() {
        return this.snapshotLabels;
    }

    public Instant getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    public int getNumberOfIssues() {
        return this.numberOfIssues;
    }

    public String getIssuesHash() {
        return this.issuesHash;
    }
}

