/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.impl;

import cdc.issues.Issue;
import cdc.issues.IssueUtils;
import cdc.issues.Labels;
import cdc.issues.Metas;
import cdc.issues.Params;
import cdc.issues.Project;
import cdc.issues.Snapshot;
import cdc.issues.impl.ProjectImpl;
import cdc.util.lang.Checks;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class SnapshotImpl
implements Snapshot {
    private final ProjectImpl project;
    private String name;
    private String description;
    private Metas metas = Metas.NO_METAS;
    private Labels labels = Labels.NO_LABELS;
    private Instant timestamp = Instant.now();
    private final List<Issue> issues = new ArrayList<Issue>();
    private String issuesHash = null;

    public SnapshotImpl() {
        this(null);
    }

    SnapshotImpl(ProjectImpl project) {
        this.project = project;
        if (project != null) {
            project.addSnapshot(this);
        }
    }

    public SnapshotImpl setName(String name) {
        this.name = name;
        return this;
    }

    public SnapshotImpl setDescription(String description) {
        this.description = description;
        return this;
    }

    @Deprecated(since="2024-03-30", forRemoval=true)
    public SnapshotImpl setMetas(Params metas) {
        return this.setMetas(Metas.of((Params)metas));
    }

    public SnapshotImpl setMetas(Metas metas) {
        this.metas = (Metas)Checks.isNotNull((Object)metas, (String)"metas");
        return this;
    }

    public SnapshotImpl setLabels(Labels labels) {
        this.labels = (Labels)Checks.isNotNull((Object)labels, (String)"labels");
        return this;
    }

    public SnapshotImpl setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public SnapshotImpl addIssue(Issue issue) {
        this.issues.add((Issue)Checks.isNotNull((Object)issue, (String)"issue"));
        this.issuesHash = null;
        return this;
    }

    public SnapshotImpl addIssues(List<? extends Issue> issues) {
        this.issues.addAll(issues);
        this.issuesHash = null;
        return this;
    }

    public Optional<Project> getProject() {
        return Optional.ofNullable(this.project);
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Metas getMetas() {
        return this.metas;
    }

    public Labels getLabels() {
        return this.labels;
    }

    public List<Issue> getIssues() {
        return Collections.unmodifiableList(this.issues);
    }

    public String getIssuesHash() {
        if (this.issuesHash == null) {
            this.issuesHash = IssueUtils.getHash(this.issues);
        }
        return this.issuesHash;
    }
}

