/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.impl;

import cdc.issues.IssueSeverity;
import cdc.issues.Labels;
import cdc.issues.Metas;
import cdc.issues.Params;
import cdc.issues.impl.ProfileConfigImpl;
import cdc.issues.rules.ConfiguredRule;
import cdc.issues.rules.Profile;
import cdc.issues.rules.ProfileConfig;
import cdc.issues.rules.Rule;
import cdc.issues.rules.RuleConfig;
import cdc.issues.rules.RuleId;
import cdc.util.lang.Checks;
import cdc.util.lang.NotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ProfileImpl
implements Profile {
    private static final String DESCRIPTION = "description";
    private static final String LABELS = "labels";
    private static final String METAS = "metas";
    private static final String PARAMS = "params";
    private static final String RULE = "rule";
    private String name;
    private String description = "";
    private Metas metas = Metas.NO_METAS;
    private Labels labels = Labels.NO_LABELS;
    private final Map<RuleId, ConfiguredRule> rules = new HashMap<RuleId, ConfiguredRule>();

    public ProfileImpl(String name) {
        this.name = name;
    }

    public ProfileImpl setName(String name) {
        this.name = name;
        return this;
    }

    public ProfileImpl setDescription(String description) {
        this.description = (String)Checks.isNotNull((Object)description, (String)DESCRIPTION);
        return this;
    }

    @Deprecated(since="2024-03-30", forRemoval=true)
    public ProfileImpl setMetas(Params metas) {
        return this.setMetas(Metas.of((Params)metas));
    }

    public ProfileImpl setMetas(Metas metas) {
        this.metas = (Metas)Checks.isNotNull((Object)metas, (String)METAS);
        return this;
    }

    public ProfileImpl setLabels(Labels labels) {
        this.labels = (Labels)Checks.isNotNull((Object)labels, (String)LABELS);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Metas getMetas() {
        return this.metas;
    }

    public Labels getLabels() {
        return this.labels;
    }

    public Rule getRule(RuleId ruleId) {
        return this.rules.get(ruleId).getRule();
    }

    public ProfileImpl add(Rule rule) {
        Checks.isNotNull((Object)rule, (String)RULE);
        Checks.assertFalse((boolean)this.rules.containsKey(rule.getId()), (String)"Duplicate rule id {} in '{}', cannot add '{}'.", (Object)rule.getId(), (Object)this.getName(), (Object)rule.getTitle());
        this.rules.put(rule.getId(), ConfiguredRule.builder((Rule)rule).enabled(true).build());
        return this;
    }

    public ProfileImpl addIfMissing(Rule rule) {
        Checks.isNotNull((Object)rule, (String)RULE);
        if (!this.rules.containsKey(rule.getId())) {
            this.rules.put(rule.getId(), ConfiguredRule.builder((Rule)rule).enabled(true).build());
        }
        return this;
    }

    public ProfileImpl setConfig(Rule rule, RuleConfig config) {
        this.addIfMissing(rule);
        this.rules.put(rule.getId(), ConfiguredRule.builder((Rule)rule).config(config).build());
        return this;
    }

    public ProfileImpl setConfig(RuleId ruleId, RuleConfig config) {
        return this.setConfig(this.getRule(ruleId), config);
    }

    public ProfileImpl remove(Rule rule) {
        Checks.isNotNull((Object)rule, (String)RULE);
        this.rules.remove(rule.getId());
        return this;
    }

    public ProfileImpl setAllEnabled(boolean enabled) {
        for (Rule rule : this.getRules()) {
            this.setEnabled(rule, enabled);
        }
        return this;
    }

    public ProfileImpl setEnabled(Rule rule, boolean enabled) {
        this.addIfMissing(rule);
        this.rules.put(rule.getId(), ConfiguredRule.builder((Rule)rule).config(this.rules.get(rule.getId()).getConfig()).enabled(enabled).build());
        return this;
    }

    public ProfileImpl setEnabled(RuleId ruleId, boolean enabled) {
        return this.setEnabled(this.getRule(ruleId), enabled);
    }

    public ProfileImpl setCustomizedSeverity(Rule rule, IssueSeverity customizedSeverity) {
        this.addIfMissing(rule);
        this.rules.put(rule.getId(), ConfiguredRule.builder((Rule)rule).config(this.rules.get(rule.getId()).getConfig()).customizedSeverity(customizedSeverity).build());
        return this;
    }

    public ProfileImpl setCustomizedSeverity(RuleId ruleId, IssueSeverity customizedSeverity) {
        return this.setCustomizedSeverity(this.getRule(ruleId), customizedSeverity);
    }

    public ProfileImpl setParams(Rule rule, Params params) {
        Checks.isNotNull((Object)params, (String)PARAMS);
        this.addIfMissing(rule);
        this.rules.put(rule.getId(), ConfiguredRule.builder((Rule)rule).config(this.rules.get(rule.getId()).getConfig()).params(params).build());
        return this;
    }

    public ProfileImpl setParams(RuleId ruleId, Params params) {
        return this.setParams(this.getRule(ruleId), params);
    }

    public ProfileImpl apply(ProfileConfig profileConfig) {
        for (RuleId ruleId : profileConfig.getRuleIds()) {
            if (!this.hasRule(ruleId)) continue;
            RuleConfig config = profileConfig.getRuleConfig(ruleId);
            this.setConfig(ruleId, config);
        }
        return this;
    }

    public Set<Rule> getRules() {
        return this.rules.values().stream().map(ConfiguredRule::getRule).collect(Collectors.toSet());
    }

    public boolean hasRule(Rule rule) {
        return rule != null && this.rules.containsKey(rule.getId());
    }

    public ProfileConfig getProfileConfig() {
        ProfileConfigImpl result = new ProfileConfigImpl();
        for (ConfiguredRule cr : this.rules.values()) {
            result.set(cr.getRule().getId(), cr.getConfig());
        }
        return result;
    }

    public boolean hasRule(RuleId ruleId) {
        return this.rules.containsKey(ruleId);
    }

    public ConfiguredRule getConfiguredRule(Rule rule) {
        Checks.isNotNull((Object)rule, (String)RULE);
        ConfiguredRule result = this.rules.get(rule.getId());
        if (result == null) {
            throw new NotFoundException("Unknown rule " + rule.getId());
        }
        return result;
    }
}

