/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.impl;

import cdc.issues.answers.IssueComment;
import java.time.Instant;
import java.util.Objects;

public class IssueCommentImpl
implements IssueComment {
    private final String author;
    private Instant date;
    private String text;

    protected IssueCommentImpl(Builder builder) {
        this.author = builder.author;
        this.date = builder.date == null ? Instant.now() : builder.date;
        this.text = builder.text;
    }

    public String getAuthor() {
        return this.author;
    }

    public Instant getDate() {
        return this.date;
    }

    public IssueCommentImpl setDate(Instant date) {
        this.date = date;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public IssueCommentImpl setText(String text) {
        this.text = text;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.author, this.date, this.text);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IssueCommentImpl)) {
            return false;
        }
        IssueCommentImpl other = (IssueCommentImpl)object;
        return Objects.equals(this.author, other.author) && Objects.equals(this.date, other.date) && Objects.equals(this.text, other.text);
    }

    public String toString() {
        return "[" + this.author + ", " + String.valueOf(this.date) + ", " + this.text + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String author;
        private Instant date;
        private String text;

        protected Builder() {
        }

        public Builder author(String author) {
            this.author = author;
            return this;
        }

        public Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public IssueCommentImpl build() {
            return new IssueCommentImpl(this);
        }
    }
}

