/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.impl;

import cdc.issues.DataSource;
import cdc.issues.IssueId;
import cdc.issues.Labels;
import cdc.issues.Metas;
import cdc.issues.Project;
import cdc.issues.answers.IssueAnswer;
import cdc.issues.impl.IssueAnswerImpl;
import cdc.issues.impl.SnapshotImpl;
import cdc.issues.rules.Profile;
import cdc.util.lang.Checks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Deprecated(since="2025-03-27", forRemoval=true)
public class ProjectImpl
implements Project {
    private String name;
    private String description;
    private Metas metas = Metas.NO_METAS;
    private Labels labels = Labels.NO_LABELS;
    private Profile profile;
    private final List<SnapshotImpl> snapshots = new ArrayList<SnapshotImpl>();
    private final Map<IssueId, IssueAnswerImpl> map = new HashMap<IssueId, IssueAnswerImpl>();
    private final Set<IssueAnswerImpl> answers = new HashSet<IssueAnswerImpl>();
    private final List<DataSource<?>> dataSources = new ArrayList();

    public ProjectImpl(String name) {
        this.name = name;
    }

    public ProjectImpl setName(String name) {
        this.name = name;
        return this;
    }

    public ProjectImpl setDescription(String description) {
        this.description = description;
        return this;
    }

    public ProjectImpl setMetas(Metas metas) {
        this.metas = (Metas)Checks.isNotNull((Object)metas, (String)"metas");
        return this;
    }

    public ProjectImpl setLabels(Labels labels) {
        this.labels = (Labels)Checks.isNotNull((Object)labels, (String)"labels");
        return this;
    }

    public ProjectImpl setProfile(Profile profile) {
        this.profile = (Profile)Checks.isNotNull((Object)profile, (String)"profile");
        return this;
    }

    void addSnapshot(SnapshotImpl snapshot) {
        this.snapshots.add((SnapshotImpl)Checks.isNotNull((Object)snapshot, (String)"snapshot"));
    }

    public SnapshotImpl createSnapshot() {
        return new SnapshotImpl(this);
    }

    public ProjectImpl addAnswer(IssueAnswerImpl answer) {
        Checks.isNotNull((Object)answer, (String)"answer");
        IssueAnswer current = this.map.get(answer.getIssueId());
        this.answers.remove(current);
        this.answers.add(answer);
        this.map.put(answer.getIssueId(), answer);
        return this;
    }

    public ProjectImpl addAnswers(Collection<IssueAnswerImpl> answers) {
        for (IssueAnswerImpl answer : answers) {
            this.addAnswer(answer);
        }
        return this;
    }

    public ProjectImpl addDataSource(DataSource<?> dataSource) {
        Checks.isNotNull(dataSource, (String)"dataSource");
        this.dataSources.add(dataSource);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Metas getMetas() {
        return this.metas;
    }

    public Labels getLabels() {
        return this.labels;
    }

    public Optional<Profile> getProfile() {
        return Optional.ofNullable(this.profile);
    }

    public Iterable<DataSource<?>> getDataSources() {
        return this.dataSources;
    }

    public List<SnapshotImpl> getSnapshots() {
        return this.snapshots;
    }

    public Set<IssueAnswerImpl> getAnswers() {
        return this.answers;
    }

    public Optional<IssueAnswer> getAnswer(IssueId id) {
        return Optional.ofNullable((IssueAnswer)this.map.get(id));
    }
}

