/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.impl;

import cdc.issues.IssueUtils;
import cdc.issues.Labels;
import cdc.issues.Metas;
import cdc.issues.Project;
import cdc.issues.Snapshot;
import cdc.issues.io.SnapshotData;
import cdc.issues.rules.Profile;
import cdc.util.lang.Checks;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;

@Deprecated(since="2025-03-25", forRemoval=true)
public class SnapshotDataImpl
implements SnapshotData {
    private final String projectName;
    private final String projectDescription;
    private final Metas projectMetas;
    private final Labels projectLabels;
    private final Optional<Profile> profile;
    private final String snapshotName;
    private final String snapshotDescription;
    private final Metas snapshotMetas;
    private final Labels snapshotLabels;
    private final Instant snapshotTimestamp;
    private final int numberOfIssues;
    private final String issuesHash;

    private SnapshotDataImpl(Builder builder) {
        this.projectName = builder.projectName;
        this.projectDescription = builder.projectDescription;
        this.projectMetas = (Metas)Checks.isNotNull((Object)builder.projectMetas, (String)"projectMetas");
        this.projectLabels = (Labels)Checks.isNotNull((Object)builder.projectLabels, (String)"projectLabels");
        this.profile = Optional.ofNullable(builder.profile);
        this.snapshotName = builder.snapshotName;
        this.snapshotDescription = builder.snapshotDescription;
        this.snapshotMetas = (Metas)Checks.isNotNull((Object)builder.snapshotMetas, (String)"snapshotMetas");
        this.snapshotLabels = (Labels)Checks.isNotNull((Object)builder.snapshotLabels, (String)"snapshotLabels");
        this.snapshotTimestamp = (Instant)Checks.isNotNull((Object)builder.snapshotTimestamp, (String)"snapshotTimestamp");
        this.numberOfIssues = builder.numberOfIssues;
        this.issuesHash = builder.issuesHash;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public Metas getProjectMetas() {
        return this.projectMetas;
    }

    public Labels getProjectLabels() {
        return this.projectLabels;
    }

    public Optional<Profile> getProfile() {
        return this.profile;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public String getSnapshotDescription() {
        return this.snapshotDescription;
    }

    public Metas getSnapshotMetas() {
        return this.snapshotMetas;
    }

    public Labels getSnapshotLabels() {
        return this.snapshotLabels;
    }

    public Instant getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    public int getNumberOfIssues() {
        return this.numberOfIssues;
    }

    public String getIssuesHash() {
        return this.issuesHash;
    }

    @Deprecated(since="2025-03-25", forRemoval=true)
    public static Builder builder() {
        return new Builder();
    }

    @Deprecated(since="2025-03-25", forRemoval=true)
    public static class Builder {
        private String projectName;
        private String projectDescription;
        private Metas projectMetas = Metas.NO_METAS;
        private Labels projectLabels = Labels.NO_LABELS;
        private Profile profile;
        private String snapshotName;
        private String snapshotDescription;
        private Metas snapshotMetas = Metas.NO_METAS;
        private Labels snapshotLabels = Labels.NO_LABELS;
        private Instant snapshotTimestamp = Instant.now();
        private int numberOfIssues = -1;
        private String issuesHash = "";

        protected Builder self() {
            return this;
        }

        public Builder snapshot(Snapshot snapshot) {
            Project project = snapshot.getProject().orElse(null);
            if (project != null) {
                this.projectName(project.getName());
                this.projectDescription(project.getDescription());
                this.projectMetas(project.getMetas());
                this.projectLabels(project.getLabels());
                if (project.getProfile().isPresent()) {
                    this.profile((Profile)project.getProfile().orElseThrow());
                }
            }
            this.snapshotName(snapshot.getName());
            this.snapshotDescription(snapshot.getDescription());
            this.snapshotMetas(snapshot.getMetas());
            this.snapshotTimestamp(snapshot.getTimestamp());
            this.numberOfIssues(snapshot.getIssues().size());
            this.issuesHash(IssueUtils.getHash((Collection)snapshot.getIssues()));
            return this.self();
        }

        public Builder projectName(String name) {
            this.projectName = name;
            return this.self();
        }

        public Builder projectDescription(String description) {
            this.projectDescription = description;
            return this.self();
        }

        public Builder projectMetas(Metas metas) {
            this.projectMetas = metas;
            return this.self();
        }

        public Builder projectLabels(Labels labels) {
            this.projectLabels = labels;
            return this.self();
        }

        public Builder profile(Profile profile) {
            this.profile = profile;
            return this.self();
        }

        public Builder snapshotName(String name) {
            this.snapshotName = name;
            return this.self();
        }

        public Builder snapshotDescription(String description) {
            this.snapshotDescription = description;
            return this.self();
        }

        public Builder snapshotMetas(Metas metas) {
            this.snapshotMetas = metas;
            return this.self();
        }

        public Builder snapshotLabels(Labels labels) {
            this.snapshotLabels = labels;
            return this.self();
        }

        public Builder snapshotTimestamp(Instant timestamp) {
            this.snapshotTimestamp = timestamp;
            return this.self();
        }

        public Builder numberOfIssues(int number) {
            this.numberOfIssues = number;
            return this.self();
        }

        public Builder issuesHash(String hash) {
            this.issuesHash = hash;
            return this.self();
        }

        public SnapshotDataImpl build() {
            return new SnapshotDataImpl(this);
        }
    }
}

