/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.impl;

import cdc.issues.IssueSeverity;
import cdc.issues.Labels;
import cdc.issues.Metas;
import cdc.issues.Params;
import cdc.issues.rules.ConfiguredRule;
import cdc.issues.rules.Profile;
import cdc.issues.rules.ProfileConfig;
import cdc.issues.rules.Rule;
import cdc.issues.rules.RuleConfig;
import cdc.issues.rules.RuleId;
import cdc.util.lang.Checks;
import cdc.util.lang.NotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Deprecated(since="2025-03-25", forRemoval=true)
public class ProfileImpl
implements Profile {
    private static final String DESCRIPTION = "description";
    private static final String LABELS = "labels";
    private static final String METAS = "metas";
    private static final String PARAMS = "params";
    private static final String RULE = "rule";
    private String name;
    private String description = "";
    private Metas metas = Metas.NO_METAS;
    private Labels labels = Labels.NO_LABELS;
    private final Map<RuleId, ConfiguredRule> configuredRules = new HashMap<RuleId, ConfiguredRule>();

    private void checkHasRule(Rule rule) {
        Checks.isNotNull((Object)rule, (String)RULE);
        Checks.isTrue((boolean)this.hasRule(rule), (String)("Unknown rule " + String.valueOf(rule)));
    }

    protected ProfileImpl(Builder builder) {
        this.name = (String)Checks.isNotNull((Object)builder.name, (String)"name");
        this.description = (String)Checks.isNotNull((Object)builder.description, (String)DESCRIPTION);
        this.metas = (Metas)Checks.isNotNull((Object)builder.metas, (String)METAS);
        this.labels = (Labels)Checks.isNotNull((Object)builder.labels, (String)LABELS);
        for (Map.Entry<RuleId, ConfiguredRule.Builder> entry : builder.configuredRules.entrySet()) {
            this.configuredRules.put(entry.getKey(), entry.getValue().build());
        }
    }

    @Deprecated(since="2025-01-25", forRemoval=true)
    public ProfileImpl(String name) {
        this.name = name;
    }

    @Deprecated(since="2025-01-25", forRemoval=true)
    public ProfileImpl setName(String name) {
        this.name = name;
        return this;
    }

    @Deprecated(since="2025-01-25", forRemoval=true)
    public ProfileImpl setDescription(String description) {
        this.description = (String)Checks.isNotNull((Object)description, (String)DESCRIPTION);
        return this;
    }

    @Deprecated(since="2025-01-25", forRemoval=true)
    public ProfileImpl setMetas(Metas metas) {
        this.metas = (Metas)Checks.isNotNull((Object)metas, (String)METAS);
        return this;
    }

    @Deprecated(since="2025-01-25", forRemoval=true)
    public ProfileImpl setLabels(Labels labels) {
        this.labels = (Labels)Checks.isNotNull((Object)labels, (String)LABELS);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Metas getMetas() {
        return this.metas;
    }

    public Labels getLabels() {
        return this.labels;
    }

    public Optional<Rule> getRule(RuleId ruleId) {
        if (this.configuredRules.containsKey(ruleId)) {
            return Optional.ofNullable(this.configuredRules.get(ruleId).getRule());
        }
        return Optional.empty();
    }

    @Deprecated(since="2025-01-25", forRemoval=true)
    public ProfileImpl add(Rule rule) {
        Checks.isNotNull((Object)rule, (String)RULE);
        Checks.assertFalse((boolean)this.configuredRules.containsKey(rule.getId()), (String)"Duplicate rule id {} in '{}', cannot add '{}'.", (Object)rule.getId(), (Object)this.getName(), (Object)rule.getTitle());
        this.configuredRules.put(rule.getId(), ConfiguredRule.builder((Rule)rule).enabled(true).build());
        return this;
    }

    @Deprecated(since="2025-01-25", forRemoval=true)
    public ProfileImpl addIfMissing(Rule rule) {
        Checks.isNotNull((Object)rule, (String)RULE);
        if (!this.configuredRules.containsKey(rule.getId())) {
            this.configuredRules.put(rule.getId(), ConfiguredRule.builder((Rule)rule).enabled(true).build());
        }
        return this;
    }

    public ProfileImpl setConfig(Rule rule, RuleConfig config) {
        this.checkHasRule(rule);
        Checks.isNotNull((Object)config, (String)"config");
        this.configuredRules.put(rule.getId(), ConfiguredRule.builder((Rule)rule).config(config).build());
        return this;
    }

    public ProfileImpl setConfig(RuleId ruleId, RuleConfig config) {
        return this.setConfig(this.getRule(ruleId).orElseThrow(), config);
    }

    @Deprecated(since="2025-01-25", forRemoval=true)
    public ProfileImpl remove(Rule rule) {
        Checks.isNotNull((Object)rule, (String)RULE);
        this.configuredRules.remove(rule.getId());
        return this;
    }

    public ProfileImpl setAllEnabled(boolean enabled) {
        for (Rule rule : this.getRules()) {
            this.setEnabled(rule, enabled);
        }
        return this;
    }

    public ProfileImpl setEnabled(Rule rule, boolean enabled) {
        this.checkHasRule(rule);
        this.configuredRules.put(rule.getId(), ConfiguredRule.builder((Rule)rule).config(this.configuredRules.get(rule.getId()).getConfig()).enabled(enabled).build());
        return this;
    }

    public ProfileImpl setEnabled(RuleId ruleId, boolean enabled) {
        return this.setEnabled(this.getRule(ruleId).orElseThrow(), enabled);
    }

    public ProfileImpl setCustomizedSeverity(Rule rule, IssueSeverity customizedSeverity) {
        this.checkHasRule(rule);
        this.configuredRules.put(rule.getId(), ConfiguredRule.builder((Rule)rule).config(this.configuredRules.get(rule.getId()).getConfig()).customizedSeverity(customizedSeverity).build());
        return this;
    }

    public ProfileImpl setCustomizedSeverity(RuleId ruleId, IssueSeverity customizedSeverity) {
        return this.setCustomizedSeverity(this.getRule(ruleId).orElseThrow(), customizedSeverity);
    }

    public ProfileImpl setParams(Rule rule, Params params) {
        this.checkHasRule(rule);
        Checks.isNotNull((Object)params, (String)PARAMS);
        this.configuredRules.put(rule.getId(), ConfiguredRule.builder((Rule)rule).config(this.configuredRules.get(rule.getId()).getConfig()).params(params).build());
        return this;
    }

    public ProfileImpl setParams(RuleId ruleId, Params params) {
        return this.setParams(this.getRule(ruleId).orElseThrow(), params);
    }

    public ProfileImpl apply(ProfileConfig profileConfig) {
        for (RuleId ruleId : profileConfig.getRuleIds()) {
            if (!this.hasRule(ruleId)) continue;
            RuleConfig config = (RuleConfig)profileConfig.getRuleConfig(ruleId).orElseThrow();
            this.setConfig(ruleId, config);
        }
        return this;
    }

    public Set<Rule> getRules() {
        return this.configuredRules.values().stream().map(ConfiguredRule::getRule).collect(Collectors.toSet());
    }

    public boolean hasRule(Rule rule) {
        return rule != null && this.configuredRules.containsKey(rule.getId());
    }

    public ProfileConfig getProfileConfig() {
        ProfileConfig.Builder result = ProfileConfig.builder();
        for (ConfiguredRule cr : this.configuredRules.values()) {
            result.set(cr.getRule().getId(), cr.getConfig());
        }
        return result.build();
    }

    public boolean hasRule(RuleId ruleId) {
        return this.configuredRules.containsKey(ruleId);
    }

    public ConfiguredRule getConfiguredRule(Rule rule) {
        Checks.isNotNull((Object)rule, (String)RULE);
        ConfiguredRule result = this.configuredRules.get(rule.getId());
        if (result == null) {
            throw new NotFoundException("Unknown rule " + String.valueOf(rule.getId()));
        }
        return result;
    }

    @Deprecated(since="2025-03-25", forRemoval=true)
    public static Builder builder() {
        return new Builder();
    }

    @Deprecated(since="2025-03-25", forRemoval=true)
    public static class Builder {
        private String name;
        private String description = "";
        private Metas metas = Metas.NO_METAS;
        private Labels labels = Labels.NO_LABELS;
        private final Map<RuleId, ConfiguredRule.Builder> configuredRules = new HashMap<RuleId, ConfiguredRule.Builder>();

        protected Builder self() {
            return this;
        }

        protected Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this.self();
        }

        public Builder description(String description) {
            this.description = description;
            return this.self();
        }

        public Builder metas(Metas metas) {
            this.metas = metas;
            return this.self();
        }

        public Builder labels(Labels labels) {
            this.labels = labels;
            return this.self();
        }

        public Builder rule(Rule rule) {
            Checks.assertFalse((boolean)this.configuredRules.containsKey(rule.getId()), (String)"Duplicate rule id {} in '{}', cannot add '{}'.", (Object)rule.getId(), (Object)this.name, (Object)rule.getTitle());
            this.configuredRules.put(((Rule)Checks.isNotNull((Object)rule, (String)ProfileImpl.RULE)).getId(), ConfiguredRule.builder((Rule)rule));
            return this.self();
        }

        public Builder enabled(Rule rule, boolean enabled) {
            ConfiguredRule.Builder b = this.configuredRules.computeIfAbsent(rule.getId(), k -> ConfiguredRule.builder((Rule)rule));
            b.enabled(enabled);
            return this.self();
        }

        public Builder customizedSeverity(Rule rule, IssueSeverity customizedSeverity) {
            ConfiguredRule.Builder b = this.configuredRules.computeIfAbsent(rule.getId(), k -> ConfiguredRule.builder((Rule)rule));
            b.customizedSeverity(customizedSeverity);
            return this.self();
        }

        public Builder params(Rule rule, Params params) {
            ConfiguredRule.Builder b = this.configuredRules.computeIfAbsent(rule.getId(), k -> ConfiguredRule.builder((Rule)rule));
            b.params(params);
            return this.self();
        }

        public ProfileImpl build() {
            return new ProfileImpl(this);
        }
    }
}

