/*
 * Decompiled with CFR 0.152.
 */
package cdc.args;

import cdc.args.Arg;
import cdc.args.Args;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.args.Necessity;
import cdc.args.Strictness;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ArgsTest {
    private static final Logger LOGGER = LogManager.getLogger(ArgsTest.class);
    private static final String AAA = "AAA";
    private static final String BBB = "BBB";
    private static final String CCC = "CCC";
    private static final String ARG0 = "arg0";
    private static final String ARG1 = "arg1";
    private static final String ARG2 = "arg2";
    private static final Arg OBJ_ARG0 = new Arg("arg0", (Object)10);
    private static final Arg STR_ARG0 = new Arg("arg0", (Object)"Hello");
    private static final FormalArg<Integer> OINT_MAN_FARG0 = new FormalArg("arg0", Integer.class, Necessity.MANDATORY);
    private static final FormalArg<Integer> PINT_MAN_FARG0 = new FormalArg("arg0", Integer.TYPE, Necessity.MANDATORY);
    private static final FormalArg<Object> OBJ_MAN_FARG0 = new FormalArg("arg0", Object.class, Necessity.MANDATORY);
    private static final FormalArg<Object> OBJ_OPT_FARG0 = new FormalArg("arg0", Object.class, Necessity.OPTIONAL);
    private static final FormalArg<Object> OBJ_MAN_FARG1 = new FormalArg("arg1", Object.class, Necessity.MANDATORY);
    private static final FormalArg<Object> OBJ_OPT_FARG1 = new FormalArg("arg1", Object.class, Necessity.OPTIONAL);
    private static final FormalArg<String> STR_MAN_FARG0 = new FormalArg("arg0", String.class, Necessity.MANDATORY);
    private static final FormalArg<String> STR_OPT_FARG0 = new FormalArg("arg0", String.class, Necessity.OPTIONAL);
    private static final FormalArg<String> STR_MAN_FARG1 = new FormalArg("arg1", String.class, Necessity.MANDATORY);
    private static final FormalArg<String> STR_OPT_FARG1 = new FormalArg("arg1", String.class, Necessity.OPTIONAL);
    private static final FormalArgs FARGS = new FormalArgs(new FormalArg[]{STR_MAN_FARG0, STR_OPT_FARG1});

    ArgsTest() {
    }

    @Test
    void testConstructors() {
        Args args = new Args();
        Assertions.assertTrue((boolean)args.isEmpty());
        Assertions.assertEquals(null, (Object)args.getValue(ARG0));
        Assertions.assertEquals((Object)AAA, (Object)args.getValue(ARG0, (Object)AAA));
        Assertions.assertEquals(null, (Object)args.getValue(ARG0, String.class));
        Assertions.assertEquals((Object)AAA, (Object)args.getValue(ARG0, String.class, (Object)AAA));
        args = Args.builder().arg(ARG0, (Object)BBB).build();
        Assertions.assertFalse((boolean)args.isEmpty());
        Assertions.assertEquals((int)1, (int)args.size());
        Assertions.assertEquals((Object)BBB, (Object)args.getValue(ARG0));
        Assertions.assertEquals((Object)BBB, (Object)args.getValue(ARG0, (Object)AAA));
        Assertions.assertEquals(null, (Object)args.getValue(ARG2));
        Assertions.assertEquals(null, (Object)args.getValue(ARG2, String.class));
        Assertions.assertEquals((Object)AAA, (Object)args.getValue(ARG2, String.class, (Object)AAA));
        args = Args.builder().arg(ARG0, (Object)BBB).arg(ARG0, (Object)CCC).arg(ARG1, (Object)BBB).build();
        Assertions.assertEquals((int)2, (int)args.size());
        Assertions.assertEquals((Object)CCC, (Object)args.getValue(ARG0));
        Assertions.assertEquals((Object)CCC, (Object)args.getValue(ARG0, String.class));
        Assertions.assertEquals((Object)CCC, (Object)args.getValue(ARG0, String.class, (Object)AAA));
        Assertions.assertEquals((Object)BBB, (Object)args.getValue(ARG1));
        Assertions.assertEquals((Object)BBB, (Object)args.getValue(ARG1, String.class));
        Assertions.assertEquals((Object)BBB, (Object)args.getValue(ARG1, String.class, (Object)AAA));
        Assertions.assertEquals(null, (Object)args.getValue(ARG2));
        Assertions.assertEquals(null, (Object)args.getValue(ARG2, String.class));
        Assertions.assertEquals((Object)AAA, (Object)args.getValue(ARG2, String.class, (Object)AAA));
        Assertions.assertTrue((boolean)args.hasArg(ARG0));
        Assertions.assertFalse((boolean)args.hasArg(ARG2));
        args = Args.builder().arg(ARG0, (Object)BBB).arg(ARG0, (Object)CCC).arg(ARG1, (Object)BBB).arg(ARG0, null).build();
        Assertions.assertEquals((int)2, (int)args.size());
        Assertions.assertEquals(null, (Object)args.getValue(ARG0));
        Args args0 = new Args(args.getArgs());
        Assertions.assertEquals((Object)args, (Object)args0);
        Args args1 = new Args();
        Assertions.assertTrue((boolean)args1.isEmpty());
        Args args2 = new Args(args1.getArgs());
        Assertions.assertEquals((Object)args1, (Object)args2);
    }

    @Test
    void testFormalAccessors() {
        Args args = Args.builder().build();
        Assertions.assertEquals(null, (Object)args.getValue(STR_MAN_FARG0));
        Assertions.assertEquals((Object)"ZZZ", (Object)args.getValue(STR_MAN_FARG0, (Object)"ZZZ"));
        args = Args.builder().arg(STR_MAN_FARG0, (Object)"Hello").build();
        Assertions.assertEquals((Object)"Hello", (Object)args.getValue(STR_MAN_FARG0));
        Assertions.assertEquals((Object)"Hello", (Object)args.getValue(STR_MAN_FARG0, (Object)AAA));
        Assertions.assertTrue((boolean)args.hasArgWithMatchingName(STR_MAN_FARG0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Args.NO_ARGS.hasArgWithMatchingName((FormalArg)null));
    }

    @Test
    void testStaticMethods() {
        Args args = new Args();
        Assertions.assertEquals((Object)AAA, (Object)Args.NO_ARGS.getValue(STR_MAN_FARG0, (Object)AAA));
        Assertions.assertEquals((Object)AAA, (Object)args.getValue(STR_MAN_FARG0, (Object)AAA));
        Assertions.assertTrue((boolean)Args.NO_ARGS.isLooselyCompliantWith(FormalArgs.NO_FARGS));
        Assertions.assertTrue((boolean)Args.NO_ARGS.isStrictlyCompliantWith(FormalArgs.NO_FARGS));
        Assertions.assertTrue((boolean)args.isLooselyCompliantWith(FormalArgs.NO_FARGS));
        Assertions.assertTrue((boolean)args.isStrictlyCompliantWith(FormalArgs.NO_FARGS));
        Assertions.assertFalse((boolean)Args.NO_ARGS.isLooselyCompliantWith(FARGS));
        Assertions.assertFalse((boolean)Args.NO_ARGS.isStrictlyCompliantWith(FARGS));
        args = Args.builder().arg(ARG0, (Object)10).build();
        Assertions.assertTrue((boolean)args.isLooselyCompliantWith(FormalArgs.NO_FARGS));
        Assertions.assertFalse((boolean)args.isStrictlyCompliantWith(FormalArgs.NO_FARGS));
        Assertions.assertFalse((boolean)args.isLooselyCompliantWith(FARGS));
    }

    @Test
    void testBasic() {
        Args args0 = new Args();
        Args args1 = new Args();
        Assertions.assertEquals((Object)args0, (Object)args0);
        Assertions.assertNotEquals((Object)args0, null);
        Assertions.assertNotEquals((Object)args0, (Object)"Hello");
        Assertions.assertEquals((Object)args0, (Object)args1);
        args0 = Args.builder().arg(ARG0, (Object)AAA).arg(ARG1, (Object)BBB).build();
        Assertions.assertNotEquals((Object)args0, (Object)args1);
        args1 = Args.builder().arg(ARG0, (Object)AAA).arg(ARG1, (Object)BBB).build();
        Assertions.assertEquals((Object)args0, (Object)args1);
        Assertions.assertEquals((Object)ARG0, args1.getNames().get(0));
        Assertions.assertEquals((Object)ARG1, args1.getNames().get(1));
        args1 = Args.builder().arg(ARG1, (Object)BBB).arg(ARG0, (Object)AAA).build();
        Assertions.assertEquals((Object)args0, (Object)args1);
        Assertions.assertEquals((Object)ARG1, args1.getNames().get(0));
        Assertions.assertEquals((Object)ARG0, args1.getNames().get(1));
        LOGGER.debug("{} {}", (Object)args0, (Object)args0.hashCode());
        args0 = Args.builder().arg(ARG0, (Object)"XXX").arg(ARG1, (Object)"XXX").build();
        LOGGER.debug("{} {}", (Object)args0, (Object)args0.hashCode());
    }

    @Test
    void testBuilder() {
        Args args0 = Args.builder().arg(ARG0, null).arg(ARG1, null).arg(ARG0, (Object)"Hello").build();
        Assertions.assertEquals((Object)ARG0, args0.getNames().get(0));
        Assertions.assertEquals((Object)ARG1, args0.getNames().get(1));
        Assertions.assertEquals((Object)"Hello", (Object)args0.getValue(ARG0));
        Assertions.assertEquals(null, (Object)args0.getValue(ARG1));
    }

    private static void testCompliance(Arg arg, FormalArg<?> farg, Strictness strictness, boolean expected) {
        Args args = Args.builder().arg(arg).build();
        FormalArgs fargs = new FormalArgs(new FormalArg[]{farg});
        Assertions.assertEquals((Object)expected, (Object)args.isCompliantWith(fargs, strictness));
    }

    @Test
    void testCompliance() {
        Assertions.assertTrue((boolean)Args.NO_ARGS.isLooselyCompliantWith(FormalArgs.NO_FARGS));
        Assertions.assertTrue((boolean)Args.NO_ARGS.isStrictlyCompliantWith(FormalArgs.NO_FARGS));
        Assertions.assertFalse((boolean)Args.NO_ARGS.isLooselyCompliantWith(FARGS));
        Assertions.assertFalse((boolean)Args.NO_ARGS.isStrictlyCompliantWith(FARGS));
        ArgsTest.testCompliance(OBJ_ARG0, OBJ_MAN_FARG0, Strictness.LOOSE, true);
        ArgsTest.testCompliance(OBJ_ARG0, OBJ_MAN_FARG0, Strictness.STRICT, true);
        ArgsTest.testCompliance(OBJ_ARG0, OBJ_OPT_FARG0, Strictness.LOOSE, true);
        ArgsTest.testCompliance(OBJ_ARG0, OBJ_OPT_FARG0, Strictness.STRICT, true);
        ArgsTest.testCompliance(OBJ_ARG0, STR_MAN_FARG0, Strictness.LOOSE, false);
        ArgsTest.testCompliance(OBJ_ARG0, STR_MAN_FARG0, Strictness.STRICT, false);
        ArgsTest.testCompliance(OBJ_ARG0, STR_OPT_FARG0, Strictness.LOOSE, false);
        ArgsTest.testCompliance(OBJ_ARG0, STR_OPT_FARG0, Strictness.STRICT, false);
        ArgsTest.testCompliance(STR_ARG0, OBJ_MAN_FARG0, Strictness.LOOSE, true);
        ArgsTest.testCompliance(STR_ARG0, OBJ_MAN_FARG0, Strictness.STRICT, true);
        ArgsTest.testCompliance(STR_ARG0, OBJ_OPT_FARG0, Strictness.LOOSE, true);
        ArgsTest.testCompliance(STR_ARG0, OBJ_OPT_FARG0, Strictness.STRICT, true);
        ArgsTest.testCompliance(STR_ARG0, STR_MAN_FARG0, Strictness.LOOSE, true);
        ArgsTest.testCompliance(STR_ARG0, STR_MAN_FARG0, Strictness.STRICT, true);
        ArgsTest.testCompliance(STR_ARG0, STR_OPT_FARG0, Strictness.LOOSE, true);
        ArgsTest.testCompliance(STR_ARG0, STR_OPT_FARG0, Strictness.STRICT, true);
        ArgsTest.testCompliance(OBJ_ARG0, OBJ_MAN_FARG1, Strictness.LOOSE, false);
        ArgsTest.testCompliance(OBJ_ARG0, OBJ_MAN_FARG1, Strictness.STRICT, false);
        ArgsTest.testCompliance(OBJ_ARG0, OBJ_OPT_FARG1, Strictness.LOOSE, true);
        ArgsTest.testCompliance(OBJ_ARG0, OBJ_OPT_FARG1, Strictness.STRICT, false);
        ArgsTest.testCompliance(OBJ_ARG0, STR_MAN_FARG1, Strictness.LOOSE, false);
        ArgsTest.testCompliance(OBJ_ARG0, STR_MAN_FARG1, Strictness.STRICT, false);
        ArgsTest.testCompliance(OBJ_ARG0, STR_OPT_FARG1, Strictness.LOOSE, true);
        ArgsTest.testCompliance(OBJ_ARG0, STR_OPT_FARG1, Strictness.STRICT, false);
        ArgsTest.testCompliance(STR_ARG0, OBJ_MAN_FARG1, Strictness.LOOSE, false);
        ArgsTest.testCompliance(STR_ARG0, OBJ_MAN_FARG1, Strictness.STRICT, false);
        ArgsTest.testCompliance(STR_ARG0, OBJ_OPT_FARG1, Strictness.LOOSE, true);
        ArgsTest.testCompliance(STR_ARG0, OBJ_OPT_FARG1, Strictness.STRICT, false);
        ArgsTest.testCompliance(STR_ARG0, STR_MAN_FARG1, Strictness.LOOSE, false);
        ArgsTest.testCompliance(STR_ARG0, STR_MAN_FARG1, Strictness.STRICT, false);
        ArgsTest.testCompliance(STR_ARG0, STR_OPT_FARG1, Strictness.LOOSE, true);
        ArgsTest.testCompliance(STR_ARG0, STR_OPT_FARG1, Strictness.STRICT, false);
        Args args = Args.builder().arg(STR_MAN_FARG0, (Object)"Hello").build();
        Assertions.assertTrue((boolean)args.isLooselyCompliantWith(FARGS));
        Assertions.assertTrue((boolean)args.isStrictlyCompliantWith(FARGS));
        Assertions.assertTrue((boolean)Args.NO_ARGS.isCompliantWith(FormalArgs.NO_FARGS, Strictness.LOOSE));
        Assertions.assertTrue((boolean)Args.NO_ARGS.isCompliantWith(FormalArgs.NO_FARGS, Strictness.STRICT));
    }

    @Test
    void testWrappedCompliance() {
        ArgsTest.testCompliance(OBJ_ARG0, OINT_MAN_FARG0, Strictness.LOOSE, true);
        ArgsTest.testCompliance(OBJ_ARG0, OINT_MAN_FARG0, Strictness.STRICT, true);
        ArgsTest.testCompliance(OBJ_ARG0, PINT_MAN_FARG0, Strictness.LOOSE, true);
        ArgsTest.testCompliance(OBJ_ARG0, PINT_MAN_FARG0, Strictness.STRICT, true);
    }

    @Test
    void testSet() {
        Args argsA = Args.builder().arg(ARG0, (Object)10).arg(ARG1, (Object)"Hello").arg(ARG2, null).build();
        LOGGER.debug("argsA: {}", (Object)argsA);
        Args argsAA = argsA.set(Args.NO_ARGS);
        Assertions.assertEquals((Object)argsA, (Object)argsAA);
        Args argsAB = Args.NO_ARGS.set(argsA);
        Assertions.assertEquals((Object)argsA, (Object)argsAB);
        Args argsB = Args.builder().arg(ARG0, (Object)20).arg(ARG2, (Object)2.0).arg("arg3", (Object)Character.valueOf('a')).build();
        LOGGER.debug("argsB: {}", (Object)argsB);
        Args argsC = argsA.set(argsB);
        LOGGER.debug("argsC: {}", (Object)argsC);
        Assertions.assertEquals((int)4, (int)argsC.size());
        Assertions.assertEquals((Object)20, (Object)argsC.getValue(ARG0));
        Assertions.assertEquals((Object)"Hello", (Object)argsC.getValue(ARG1));
        Assertions.assertEquals((Object)2.0, (Object)argsC.getValue(ARG2));
        Assertions.assertEquals((Object)Character.valueOf('a'), (Object)argsC.getValue("arg3"));
    }

    @Test
    void testNoArg() {
        Assertions.assertEquals((int)0, (int)Args.NO_ARGS.size());
        Assertions.assertTrue((boolean)Args.NO_ARGS.isEmpty());
        Assertions.assertEquals(null, (Object)Args.NO_ARGS.getValue("Hello"));
        Assertions.assertEquals((Object)"World", (Object)Args.NO_ARGS.getValue("Hello", (Object)"World"));
    }

    @Test
    void testObject() {
        Args args = Args.builder().arg("Hello", null).build();
        Assertions.assertTrue((boolean)args.hasArg("Hello"));
        Assertions.assertEquals(null, (Object)args.getValue("Hello"));
        Assertions.assertEquals(null, (Object)args.getValue("Hello", (Object)"World"));
    }

    @Test
    void testClass() {
        Args args = Args.builder().arg("Hello", (Object)10).build();
        Assertions.assertTrue((boolean)args.hasArg("Hello"));
        Assertions.assertEquals((int)10, (int)((Integer)args.getValue("Hello", Integer.class)));
        Assertions.assertEquals(null, (Integer)((Integer)args.getValue("World", Integer.class)));
        Assertions.assertEquals((int)20, (int)((Integer)args.getValue("World", Integer.class, (Object)20)));
    }

    @Test
    void testGetArg() {
        Args args = Args.builder().arg(ARG0, (Object)10).arg(ARG1, (Object)"Hello").arg(ARG2, null).build();
        Assertions.assertEquals((Object)new Arg(ARG0, (Object)10), (Object)args.getArg(ARG0));
        Assertions.assertEquals(null, (Object)args.getArg("ARG0"));
    }

    @Test
    void testGetArgs() {
        Args args = Args.builder().arg(ARG0, (Object)10).arg(ARG1, (Object)"Hello").arg(ARG2, null).build();
        Assertions.assertEquals((int)3, (int)args.getArgs().size());
    }

    @Test
    void testGetValue() {
        FormalArg farg = new FormalArg("x", Integer.TYPE, Necessity.MANDATORY);
        LOGGER.info("farg: {}", (Object)farg);
        Args args = Args.builder().arg(farg, (Object)10).build();
        LOGGER.info("args: {}", (Object)args);
        int x = (Integer)args.getValue(farg);
        LOGGER.info("x: {}", (Object)x);
        Assertions.assertTrue((boolean)true);
    }
}

