/*
 * Decompiled with CFR 0.152.
 */
package cdc.args;

import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.args.Necessity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FormalArgsTest {
    private static final Logger LOGGER = LogManager.getLogger(FormalArgsTest.class);
    private static final FormalArg<Integer> IMARG0 = new FormalArg("arg0", Integer.class, Necessity.MANDATORY);
    private static final FormalArg<Integer> PIMARG0 = new FormalArg("arg0", Integer.TYPE, Necessity.MANDATORY);
    private static final FormalArg<String> SMARG0 = new FormalArg("arg0", String.class, Necessity.MANDATORY);
    private static final FormalArg<String> SOARG0 = new FormalArg("arg0", String.class, Necessity.OPTIONAL);
    private static final FormalArg<Object> OMARG0 = new FormalArg("arg0", Object.class, Necessity.MANDATORY);
    private static final FormalArg<Object> OOARG0 = new FormalArg("arg0", Object.class, Necessity.OPTIONAL);
    private static final FormalArg<Object> OMARG1 = new FormalArg("arg1", Object.class, Necessity.MANDATORY);
    private static final FormalArg<Object> OOARG1 = new FormalArg("arg1", Object.class, Necessity.OPTIONAL);

    FormalArgsTest() {
    }

    @Test
    void testConstructors() {
        FormalArgs fargs0 = new FormalArgs();
        Assertions.assertEquals((int)0, (int)fargs0.size());
        FormalArgs fargs1 = new FormalArgs(new FormalArg[]{SMARG0, OOARG1});
        Assertions.assertEquals((int)2, (int)fargs1.size());
        Assertions.assertEquals(SMARG0, (Object)fargs1.getArg(0));
        Assertions.assertEquals(OOARG1, (Object)fargs1.getArg(1));
        Assertions.assertEquals((int)0, (int)fargs1.getArgIndex("arg0"));
        Assertions.assertEquals((int)1, (int)fargs1.getArgIndex("arg1"));
        Assertions.assertEquals((int)-1, (int)fargs1.getArgIndex("arg2"));
        Assertions.assertEquals((int)-1, (int)fargs1.getArgIndex("Arg0"));
        FormalArgs m = fargs1.getArgs(Necessity.MANDATORY);
        Assertions.assertEquals((int)1, (int)m.size());
    }

    @Test
    void testConstructors2() {
        FormalArgs fargs0 = new FormalArgs();
        Assertions.assertEquals((int)0, (int)fargs0.size());
        FormalArgs fargs1 = new FormalArgs(new FormalArg[]{SMARG0, OOARG1});
        Assertions.assertEquals((int)2, (int)fargs1.size());
        FormalArgs fargs00 = new FormalArgs(fargs0, fargs0);
        Assertions.assertEquals((int)0, (int)fargs00.size());
        Assertions.assertThrows(IllegalArgumentException.class, () -> new FormalArgs(null, null));
        FormalArgs fargs01 = new FormalArgs(fargs0, fargs1);
        Assertions.assertEquals((int)2, (int)fargs01.size());
        FormalArgs fargs10 = new FormalArgs(fargs1, fargs0);
        Assertions.assertEquals((int)2, (int)fargs10.size());
        Assertions.assertThrows(IllegalArgumentException.class, () -> new FormalArgs(fargs1, fargs1));
    }

    @Test
    void testEquals() {
        Assertions.assertEquals((Object)new FormalArgs(), (Object)new FormalArgs());
        Assertions.assertEquals((Object)new FormalArgs(new FormalArg[]{SMARG0}), (Object)new FormalArgs(new FormalArg[]{SMARG0}));
        Assertions.assertNotEquals((Object)new FormalArgs(new FormalArg[]{SMARG0}), (Object)new FormalArgs(new FormalArg[]{SOARG0}));
        Assertions.assertNotEquals((Object)new FormalArgs(new FormalArg[]{SMARG0}), null);
        FormalArgs fargs = new FormalArgs(new FormalArg[]{SMARG0});
        Assertions.assertEquals((Object)fargs, (Object)fargs);
    }

    @Test
    void testAccepts() {
        Assertions.assertTrue((boolean)FormalArgs.NO_FARGS.accepts(FormalArgs.NO_FARGS));
        Assertions.assertTrue((boolean)FormalArgs.NO_FARGS.accepts(new FormalArgs(new FormalArg[]{SMARG0})));
        Assertions.assertFalse((boolean)new FormalArgs(new FormalArg[]{SMARG0}).accepts(FormalArgs.NO_FARGS));
        Assertions.assertTrue((boolean)new FormalArgs(new FormalArg[]{SOARG0}).accepts(FormalArgs.NO_FARGS));
        Assertions.assertTrue((boolean)new FormalArgs(new FormalArg[]{SOARG0}).accepts(new FormalArgs(new FormalArg[]{SOARG0})));
        Assertions.assertTrue((boolean)new FormalArgs(new FormalArg[]{SOARG0}).accepts(new FormalArgs(new FormalArg[]{SMARG0})));
        Assertions.assertTrue((boolean)new FormalArgs(new FormalArg[]{SOARG0}).accepts(new FormalArgs(new FormalArg[]{SMARG0, OMARG1})));
        Assertions.assertTrue((boolean)new FormalArgs(new FormalArg[]{SOARG0}).accepts(new FormalArgs(new FormalArg[]{SMARG0, OOARG1})));
        Assertions.assertTrue((boolean)new FormalArgs(new FormalArg[]{SOARG0}).accepts(new FormalArgs(new FormalArg[]{SOARG0, OMARG1})));
        Assertions.assertTrue((boolean)new FormalArgs(new FormalArg[]{SOARG0}).accepts(new FormalArgs(new FormalArg[]{SOARG0, OOARG1})));
        Assertions.assertFalse((boolean)new FormalArgs(new FormalArg[]{SMARG0}).accepts(FormalArgs.NO_FARGS));
        Assertions.assertTrue((boolean)new FormalArgs(new FormalArg[]{SMARG0}).accepts(new FormalArgs(new FormalArg[]{SOARG0})));
        Assertions.assertTrue((boolean)new FormalArgs(new FormalArg[]{SMARG0}).accepts(new FormalArgs(new FormalArg[]{SMARG0})));
        Assertions.assertTrue((boolean)new FormalArgs(new FormalArg[]{SMARG0}).accepts(new FormalArgs(new FormalArg[]{SMARG0, OMARG1})));
        Assertions.assertTrue((boolean)new FormalArgs(new FormalArg[]{SMARG0}).accepts(new FormalArgs(new FormalArg[]{SMARG0, OOARG1})));
        Assertions.assertTrue((boolean)new FormalArgs(new FormalArg[]{SMARG0}).accepts(new FormalArgs(new FormalArg[]{SOARG0, OMARG1})));
        Assertions.assertTrue((boolean)new FormalArgs(new FormalArg[]{SMARG0}).accepts(new FormalArgs(new FormalArg[]{SOARG0, OOARG1})));
    }

    @Test
    void testAcceptsWrap() {
        Assertions.assertFalse((boolean)new FormalArgs(new FormalArg[]{IMARG0}).accepts(FormalArgs.NO_FARGS));
        Assertions.assertTrue((boolean)new FormalArgs(new FormalArg[]{IMARG0}).accepts(new FormalArgs(new FormalArg[]{IMARG0})));
        Assertions.assertTrue((boolean)new FormalArgs(new FormalArg[]{IMARG0}).accepts(new FormalArgs(new FormalArg[]{PIMARG0})));
        Assertions.assertTrue((boolean)new FormalArgs(new FormalArg[]{PIMARG0}).accepts(new FormalArgs(new FormalArg[]{PIMARG0})));
        Assertions.assertTrue((boolean)new FormalArgs(new FormalArg[]{PIMARG0}).accepts(new FormalArgs(new FormalArg[]{IMARG0})));
    }

    private static void testMerge(FormalArgs left, FormalArgs right, FormalArg<?> expected) {
        FormalArgs fargs = FormalArgs.merge((FormalArgs)left, (FormalArgs)right);
        Assertions.assertEquals((int)1, (int)fargs.size());
        Assertions.assertEquals(expected, (Object)fargs.getArg(expected.getName()));
    }

    @Test
    void testMerge() {
        FormalArgsTest.testMerge(new FormalArgs(new FormalArg[]{SMARG0}), FormalArgs.NO_FARGS, SMARG0);
        FormalArgsTest.testMerge(FormalArgs.NO_FARGS, new FormalArgs(new FormalArg[]{SMARG0}), SMARG0);
        FormalArgsTest.testMerge(new FormalArgs(new FormalArg[]{SMARG0}), new FormalArgs(new FormalArg[]{SMARG0}), SMARG0);
        FormalArgsTest.testMerge(new FormalArgs(new FormalArg[]{SMARG0}), new FormalArgs(new FormalArg[]{SOARG0}), SMARG0);
        FormalArgsTest.testMerge(new FormalArgs(new FormalArg[]{SOARG0}), new FormalArgs(new FormalArg[]{SMARG0}), SMARG0);
        FormalArgsTest.testMerge(new FormalArgs(new FormalArg[]{SOARG0}), new FormalArgs(new FormalArg[]{SOARG0}), SOARG0);
        FormalArgsTest.testMerge(new FormalArgs(new FormalArg[]{SMARG0}), new FormalArgs(new FormalArg[]{OMARG0}), SMARG0);
        FormalArgsTest.testMerge(new FormalArgs(new FormalArg[]{SMARG0}), new FormalArgs(new FormalArg[]{OOARG0}), SMARG0);
        FormalArgsTest.testMerge(new FormalArgs(new FormalArg[]{SOARG0}), new FormalArgs(new FormalArg[]{OMARG0}), SMARG0);
        FormalArgsTest.testMerge(new FormalArgs(new FormalArg[]{SOARG0}), new FormalArgs(new FormalArg[]{OOARG0}), SOARG0);
        FormalArgsTest.testMerge(new FormalArgs(new FormalArg[]{OMARG0}), new FormalArgs(new FormalArg[]{SMARG0}), SMARG0);
        FormalArgsTest.testMerge(new FormalArgs(new FormalArg[]{OOARG0}), new FormalArgs(new FormalArg[]{SMARG0}), SMARG0);
        FormalArgsTest.testMerge(new FormalArgs(new FormalArg[]{OMARG0}), new FormalArgs(new FormalArg[]{SOARG0}), SMARG0);
        FormalArgsTest.testMerge(new FormalArgs(new FormalArg[]{OOARG0}), new FormalArgs(new FormalArg[]{SOARG0}), SOARG0);
    }

    private static void testInvalidMerge(FormalArgs left, FormalArgs right) {
        FormalArgs.merge((FormalArgs)left, (FormalArgs)right);
    }

    @Test
    void testInvalidMerge() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FormalArgsTest.testInvalidMerge(new FormalArgs(new FormalArg[]{IMARG0}), new FormalArgs(new FormalArg[]{SMARG0})));
    }

    @Test
    void testBasic() {
        FormalArgs fargs1 = new FormalArgs(new FormalArg[]{SMARG0, OOARG1});
        LOGGER.debug("{} {}", (Object)fargs1, (Object)fargs1.hashCode());
    }

    @Test
    void testBuilder() {
        FormalArgs fargs1 = FormalArgs.builder().build();
        Assertions.assertTrue((boolean)fargs1.isEmpty());
        FormalArgs fargs2 = FormalArgs.builder().add("Hello", String.class, Necessity.MANDATORY).build();
        Assertions.assertEquals((int)1, (int)fargs2.size());
        FormalArgs fargs3 = FormalArgs.builder().add("Hello", String.class, Necessity.MANDATORY).clear().build();
        Assertions.assertTrue((boolean)fargs3.isEmpty());
    }

    @Test
    void testHasArg() {
        Assertions.assertFalse((boolean)FormalArgs.NO_FARGS.hasArgs(Necessity.MANDATORY));
        Assertions.assertFalse((boolean)FormalArgs.NO_FARGS.hasArgs(Necessity.OPTIONAL));
        FormalArgs fargs = FormalArgs.builder().add("Hello", String.class, Necessity.MANDATORY).build();
        Assertions.assertTrue((boolean)fargs.hasArgs(Necessity.MANDATORY));
        Assertions.assertFalse((boolean)fargs.hasArgs(Necessity.OPTIONAL));
    }
}

