/*
 * Decompiled with CFR 0.152.
 */
package cdc.args;

import cdc.args.Arg;
import cdc.args.Args;
import cdc.args.AutoFactory;
import cdc.args.Factory;
import cdc.args.FormalArgs;
import cdc.args.Necessity;
import cdc.util.debug.Printable;
import cdc.util.debug.Printables;
import cdc.util.lang.Checks;
import cdc.util.lang.CollectionUtils;
import cdc.util.lang.ComparatorUtils;
import cdc.util.lang.FailureReaction;
import cdc.util.lang.Introspection;
import cdc.util.lang.NotFoundException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Factories {
    private static final Logger LOGGER = LogManager.getLogger(Factories.class);
    private static final Map<Class<?>, Factory<?>> MAP = new HashMap();
    private static final Set<Class<?>> AUTO_FAILURES = new HashSet();
    public static final Printable PRINTER = new Printer();
    private static final String CONVERTERS_NOT_SET = "Converter was not set. You should call Factories.setConverter(ArgsConversion::convert) for example.";
    private static ArgsConverter converter;

    private Factories() {
    }

    public static void setConverter(ArgsConverter converter) {
        Factories.converter = converter;
    }

    private static void warnMissingConverter() {
        LOGGER.error(CONVERTERS_NOT_SET);
    }

    private static Args convert(Args args, Factory<?> factory) {
        if (converter == null) {
            Factories.warnMissingConverter();
            return args;
        }
        return converter.apply(args, factory.getCreationFormalArgsList());
    }

    private static boolean needsStringConversion(Arg arg) {
        return !arg.isCompliantWith(String.class);
    }

    private static boolean needsStringConversion(Args args) {
        for (Arg arg : args.getArgs()) {
            if (!Factories.needsStringConversion(arg)) continue;
            return true;
        }
        return false;
    }

    public static Arg convertToStringValues(Arg arg) {
        boolean needsConversion = Factories.needsStringConversion(arg);
        if (needsConversion) {
            if (converter == null) {
                Factories.warnMissingConverter();
                throw new IllegalArgumentException(CONVERTERS_NOT_SET);
            }
            FormalArgs fargs = FormalArgs.builder().add(arg.getName(), String.class, Necessity.OPTIONAL).build();
            ArrayList<FormalArgs> fargsList = new ArrayList<FormalArgs>();
            fargsList.add(fargs);
            Args args = converter.apply(new Args(arg), fargsList);
            return args.getArgs().get(0);
        }
        return arg;
    }

    public static Args convertToStringValues(Args args) {
        boolean needsConversion = Factories.needsStringConversion(args);
        if (needsConversion) {
            if (converter == null) {
                Factories.warnMissingConverter();
                throw new IllegalArgumentException(CONVERTERS_NOT_SET);
            }
            FormalArgs.Builder fbuilder = FormalArgs.builder();
            for (Arg arg : args.getArgs()) {
                fbuilder.add(arg.getName(), String.class, Necessity.OPTIONAL);
            }
            FormalArgs fargs = fbuilder.build();
            ArrayList<FormalArgs> fargsList = new ArrayList<FormalArgs>();
            fargsList.add(fargs);
            return converter.apply(args, fargsList);
        }
        return args;
    }

    public static void register(Factory<?> factory) {
        LOGGER.debug("register({})", factory);
        Checks.isNotNull(factory, (String)"factory");
        Checks.isNotNullOrEmpty(factory.getCreationFormalArgsList(), (String)"factory.creationArgs");
        if (MAP.containsKey(factory.getObjectClass())) {
            if (MAP.get(factory.getObjectClass()) == factory) {
                LOGGER.debug("Ignored");
                return;
            }
            throw new IllegalArgumentException("A '" + factory.getObjectClass().getCanonicalName() + "' factory is already registered");
        }
        MAP.put(factory.getObjectClass(), factory);
    }

    public static Set<Class<?>> getClasses() {
        return MAP.keySet();
    }

    public static <T> Factory<T> getFactory(Class<T> cls, FailureReaction reaction) {
        Checks.isNotNull(cls, (String)"cls");
        Factory<T> result = (Factory<T>)Introspection.uncheckedCast(MAP.get(cls));
        if (result == null && !AUTO_FAILURES.contains(cls)) {
            result = Factories.detectFactory(cls);
            if (result == null) {
                try {
                    result = new AutoFactory<T>(cls);
                    LOGGER.debug("Created an auto factory for {}", (Object)cls.getCanonicalName());
                    Factories.register(result);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to create an auto factory for {}", (Object)cls.getCanonicalName(), (Object)e);
                    AUTO_FAILURES.add(cls);
                    result = null;
                }
            } else {
                LOGGER.debug("Auto detected a factory for {}", (Object)cls.getCanonicalName());
                Factories.register(result);
            }
        }
        return (Factory)NotFoundException.onResult(result, (String)("No '" + cls.getCanonicalName() + "' factory found"), (Logger)LOGGER, (FailureReaction)reaction, null);
    }

    public static <T> Factory<T> getFactory(Class<T> cls) {
        return Factories.getFactory(cls, FailureReaction.FAIL);
    }

    private static <T> boolean isMatchingFactory(Field field, Class<T> objectClass) {
        try {
            return Modifier.isStatic(field.getModifiers()) && Factory.class.isAssignableFrom(field.getType()) && ((Factory)field.get(null)).getObjectClass().equals(objectClass);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOGGER.error("Failed to retrieve {} in {}", (Object)field, (Object)objectClass.getCanonicalName());
            return false;
        }
    }

    private static <T> boolean isCompliantFactory(Field field, Class<T> objectClass) {
        try {
            return Modifier.isStatic(field.getModifiers()) && Factory.class.isAssignableFrom(field.getType()) && objectClass.isAssignableFrom(((Factory)field.get(null)).getObjectClass());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOGGER.error("Failed to retrieve {} in {}", (Object)field, (Object)objectClass.getCanonicalName());
            return false;
        }
    }

    private static <T> Factory<T> detectFactory(Class<T> objectClass) {
        Set matchingFields = Introspection.getFieldsMatching(objectClass, field -> Factories.isMatchingFactory(field, objectClass));
        if (matchingFields.size() == 1) {
            Field field2 = (Field)matchingFields.iterator().next();
            try {
                Factory factory = (Factory)field2.get(null);
                LOGGER.debug("Found one matching factory in {}", (Object)objectClass.getCanonicalName());
                return (Factory)Introspection.uncheckedCast((Object)factory);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LOGGER.error("Failed to retrieve {} in {}", (Object)field2, (Object)objectClass.getCanonicalName());
                return null;
            }
        }
        if (matchingFields.size() > 1) {
            LOGGER.warn("Too many ({}) matching factories found in {}", (Object)matchingFields.size(), (Object)objectClass.getCanonicalName());
        } else {
            Set compliantFields = Introspection.getFieldsMatching(objectClass, field -> Factories.isCompliantFactory(field, objectClass));
            if (compliantFields.size() == 1) {
                Field field3 = (Field)compliantFields.iterator().next();
                try {
                    Factory factory = (Factory)field3.get(null);
                    LOGGER.debug("Found one compliant factory in {}", (Object)objectClass.getCanonicalName());
                    return (Factory)Introspection.uncheckedCast((Object)factory);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOGGER.error("Failed to retrieve {} in {}", (Object)field3, (Object)objectClass.getCanonicalName());
                    return null;
                }
            }
            if (compliantFields.size() > 1) {
                LOGGER.warn("Too many ({}) compliant factories found in {}", (Object)compliantFields.size(), (Object)objectClass.getCanonicalName());
            }
        }
        LOGGER.warn("No factories found in {}", (Object)objectClass.getCanonicalName());
        return null;
    }

    public static Object create(Class<?> cls, Args args) {
        LOGGER.debug("create({}, {})", cls, (Object)args);
        Checks.isNotNull(cls, (String)"cls");
        Checks.isNotNull((Object)args, (String)"args");
        Factory<?> factory = Factories.getFactory(cls, FailureReaction.FAIL);
        return factory.create(Factories.convert(args, factory));
    }

    public static Object create(Class<?> cls) {
        return Factories.create(cls, Args.NO_ARGS);
    }

    public static Object create(String className, Args args) {
        LOGGER.debug("create({}, {})", (Object)className, (Object)args);
        Class cls = Introspection.getClass((String)className, (FailureReaction)FailureReaction.FAIL);
        return Factories.create(cls, args);
    }

    public static Object create(String className) {
        return Factories.create(className, Args.NO_ARGS);
    }

    static {
        Printables.register(Factories.class, (Printable)PRINTER);
        converter = null;
    }

    protected static class Printer
    implements Printable {
        protected Printer() {
        }

        public void print(PrintStream out, int level) {
            this.indent(out, level);
            out.println("Factories (" + Factories.getClasses().size() + ")");
            for (Class cls : CollectionUtils.toSortedList(Factories.getClasses(), (Comparator)ComparatorUtils.CLASS_CANONICAL_NAME_COMPARATOR)) {
                Factory factory = Factories.getFactory(cls);
                this.indent(out, level + 1);
                out.println(factory.getObjectClass().getCanonicalName());
                for (FormalArgs fargs : factory.getCreationFormalArgsList()) {
                    this.indent(out, level + 2);
                    out.println("fargs: " + fargs);
                }
                this.indent(out, level + 2);
                out.println("meta: " + factory.getMeta());
            }
        }
    }

    @FunctionalInterface
    public static interface ArgsConverter {
        public Args apply(Args var1, List<FormalArgs> var2);
    }
}

