/*
 * Decompiled with CFR 0.152.
 */
package cdc.args;

import cdc.args.Arg;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.args.Necessity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ArgTest {
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String FOO = "foo";

    ArgTest() {
    }

    @Test
    void testEquals() {
        Arg arg1 = new Arg(NAME, (Object)VALUE);
        Arg arg2 = new Arg(NAME, (Object)VALUE);
        Arg arg3 = new Arg(NAME, (Object)FOO);
        Arg arg4 = new Arg(FOO, (Object)VALUE);
        Assertions.assertEquals((Object)NAME, (Object)arg1.getName());
        Assertions.assertEquals((Object)VALUE, (Object)arg1.getValue());
        Assertions.assertEquals((Object)arg1, (Object)arg1);
        Assertions.assertEquals((Object)arg1, (Object)arg2);
        Assertions.assertNotEquals((Object)arg1, (Object)"Hello");
        Assertions.assertNotEquals((Object)arg1, (Object)arg3);
        Assertions.assertNotEquals((Object)arg3, (Object)arg4);
    }

    @Test
    void testConstructors() {
        Arg arg0 = new Arg(NAME, (Object)VALUE);
        Assertions.assertEquals((Object)NAME, (Object)arg0.getName());
        FormalArg farg = new FormalArg(NAME, Integer.class, Necessity.OPTIONAL);
        Arg arg1 = new Arg(farg, null);
        Assertions.assertEquals((Object)NAME, (Object)arg1.getName());
    }

    @Test
    void testClassAccessors() {
        Arg arg0 = new Arg(NAME, null);
        Assertions.assertEquals(null, (Object)arg0.getValue(String.class));
        Assertions.assertEquals((Object)VALUE, (Object)arg0.getValue(String.class, (Object)VALUE));
        Arg arg1 = new Arg(NAME, (Object)VALUE);
        Assertions.assertEquals((Object)VALUE, (Object)arg1.getValue(String.class));
        Assertions.assertEquals((Object)VALUE, (Object)arg1.getValue(String.class, (Object)FOO));
    }

    @Test
    void testObjectAccessors() {
        Arg arg0 = new Arg(NAME, null);
        Assertions.assertEquals(null, (Object)arg0.getValue());
        Assertions.assertEquals(null, (Object)arg0.getValue(null));
        Assertions.assertEquals((Object)VALUE, (Object)arg0.getValue((Object)VALUE));
        Arg arg1 = new Arg(NAME, (Object)VALUE);
        Assertions.assertEquals((Object)VALUE, (Object)arg1.getValue());
        Assertions.assertEquals((Object)VALUE, (Object)arg1.getValue(null));
        Assertions.assertEquals((Object)VALUE, (Object)arg1.getValue((Object)FOO));
    }

    @Test
    void testIsCompliantWithFormalArg() {
        Arg arg0 = new Arg(NAME, null);
        Arg arg1 = new Arg(NAME, (Object)VALUE);
        FormalArg snm = new FormalArg(NAME, String.class, Necessity.MANDATORY);
        FormalArg sno = new FormalArg(NAME, String.class, Necessity.OPTIONAL);
        FormalArg sfm = new FormalArg(FOO, String.class, Necessity.MANDATORY);
        FormalArg sfo = new FormalArg(FOO, String.class, Necessity.OPTIONAL);
        FormalArg inm = new FormalArg(NAME, Integer.class, Necessity.MANDATORY);
        FormalArg ino = new FormalArg(NAME, Integer.class, Necessity.OPTIONAL);
        Assertions.assertFalse((boolean)arg0.isCompliantWith(snm));
        Assertions.assertTrue((boolean)arg0.isCompliantWith(sno));
        Assertions.assertFalse((boolean)arg0.isCompliantWith(sfm));
        Assertions.assertFalse((boolean)arg0.isCompliantWith(sfo));
        Assertions.assertFalse((boolean)arg0.isCompliantWith(inm));
        Assertions.assertTrue((boolean)arg0.isCompliantWith(ino));
        Assertions.assertTrue((boolean)arg1.isCompliantWith(snm));
        Assertions.assertTrue((boolean)arg1.isCompliantWith(sno));
        Assertions.assertFalse((boolean)arg1.isCompliantWith(sfm));
        Assertions.assertFalse((boolean)arg1.isCompliantWith(sfo));
        Assertions.assertFalse((boolean)arg1.isCompliantWith(inm));
        Assertions.assertFalse((boolean)arg1.isCompliantWith(ino));
    }

    @Test
    void testIsCompliantWithFormalArgs() {
        Arg arg0 = new Arg(NAME, null);
        Arg arg1 = new Arg(NAME, (Object)VALUE);
        FormalArgs fargs0 = new FormalArgs(new FormalArg[]{new FormalArg(NAME, String.class, Necessity.MANDATORY)});
        Assertions.assertFalse((boolean)arg0.isCompliantWith(fargs0));
        Assertions.assertTrue((boolean)arg1.isCompliantWith(fargs0));
        FormalArgs fargs1 = new FormalArgs(new FormalArg[]{new FormalArg(NAME, String.class, Necessity.OPTIONAL)});
        Assertions.assertTrue((boolean)arg0.isCompliantWith(fargs1));
        Assertions.assertTrue((boolean)arg1.isCompliantWith(fargs1));
    }

    void testFormalConstructor() {
        FormalArg farg1 = new FormalArg(NAME, Integer.class, Necessity.MANDATORY);
        FormalArg farg2 = new FormalArg(NAME, Integer.class, Necessity.OPTIONAL);
        Arg arg1 = new Arg(farg1, (Object)10);
        Assertions.assertEquals((int)10, (int)((Integer)arg1.getValue(Integer.class)));
        Arg arg2 = new Arg(farg2, (Object)10);
        Assertions.assertEquals((int)10, (int)((Integer)arg2.getValue(Integer.class)));
        Arg arg3 = new Arg(farg2, null);
        Assertions.assertEquals(null, (Object)arg3.getValue());
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Arg(farg1, null));
    }
}

