/*
 * Decompiled with CFR 0.152.
 */
package cdc.args;

import cdc.args.FormalArg;
import cdc.args.Necessity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FormalArgTest {
    private static final Logger LOGGER = LogManager.getLogger(FormalArgTest.class);

    FormalArgTest() {
    }

    @Test
    void testConstructor() {
        FormalArg farg0 = new FormalArg("Arg1", String.class, Necessity.MANDATORY);
        Assertions.assertEquals((Object)"Arg1", (Object)farg0.getName());
        Assertions.assertEquals(String.class, (Object)farg0.getType());
        Assertions.assertEquals((Object)Necessity.MANDATORY, (Object)farg0.getNecessity());
        Assertions.assertTrue((boolean)farg0.isMandatory());
        Assertions.assertFalse((boolean)farg0.isOptional());
        FormalArg farg1 = new FormalArg("Arg1", String.class, Necessity.OPTIONAL);
        Assertions.assertFalse((boolean)farg1.isMandatory());
        Assertions.assertTrue((boolean)farg1.isOptional());
        FormalArg farg2 = new FormalArg("Arg1", String.class);
        Assertions.assertTrue((boolean)farg2.isMandatory());
        Assertions.assertFalse((boolean)farg2.isOptional());
    }

    @Test
    void testIsValidName() {
        Assertions.assertTrue((boolean)FormalArg.isValidName((String)"Hello"));
        Assertions.assertTrue((boolean)FormalArg.isValidName((String)"Hello world"));
        Assertions.assertFalse((boolean)FormalArg.isValidName(null));
    }

    @Test
    void testCheckName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FormalArg.checkName(null));
        FormalArg.checkName((String)"");
        FormalArg.checkName((String)"   aaa aaa   ");
    }

    @Test
    void testIsCompliantWith() {
        FormalArg farg0 = new FormalArg("Arg0", Object.class, Necessity.MANDATORY);
        Assertions.assertTrue((boolean)farg0.isCompliantWith((Object)"Hello"));
        Assertions.assertTrue((boolean)farg0.isCompliantWith((Object)10));
        Assertions.assertFalse((boolean)farg0.isCompliantWith(null));
        FormalArg farg1 = new FormalArg("Arg1", String.class, Necessity.OPTIONAL);
        Assertions.assertTrue((boolean)farg1.isCompliantWith((Object)"Hello"));
        Assertions.assertFalse((boolean)farg1.isCompliantWith((Object)10));
        Assertions.assertTrue((boolean)farg1.isCompliantWith(null));
        FormalArg farg2 = new FormalArg("Arg2", Float.TYPE, Necessity.OPTIONAL);
        Assertions.assertTrue((boolean)farg2.isCompliantWith((Object)Float.valueOf(10.0f)));
        FormalArg farg3 = new FormalArg("Arg2", Float.class, Necessity.OPTIONAL);
        Assertions.assertTrue((boolean)farg3.isCompliantWith((Object)Float.valueOf(10.0f)));
    }

    @Test
    void testIsWeakerThan() {
        FormalArg marg0 = new FormalArg("Arg0", Object.class, Necessity.MANDATORY);
        FormalArg oarg0 = new FormalArg("Arg0", Object.class, Necessity.OPTIONAL);
        FormalArg marg1 = new FormalArg("Arg0", String.class, Necessity.MANDATORY);
        FormalArg oarg1 = new FormalArg("Arg0", String.class, Necessity.OPTIONAL);
        Assertions.assertTrue((boolean)marg0.isWeakerThan(marg0));
        Assertions.assertFalse((boolean)marg0.isWeakerThan(oarg0));
        Assertions.assertTrue((boolean)oarg0.isWeakerThan(marg0));
        Assertions.assertTrue((boolean)oarg0.isWeakerThan(oarg0));
        Assertions.assertTrue((boolean)marg0.isWeakerThan(marg1));
        Assertions.assertFalse((boolean)marg0.isWeakerThan(oarg1));
        Assertions.assertTrue((boolean)oarg0.isWeakerThan(marg1));
        Assertions.assertTrue((boolean)oarg0.isWeakerThan(oarg1));
        Assertions.assertTrue((boolean)marg1.isWeakerThan(marg1));
        Assertions.assertFalse((boolean)marg1.isWeakerThan(oarg1));
        Assertions.assertTrue((boolean)oarg1.isWeakerThan(marg1));
        Assertions.assertTrue((boolean)oarg1.isWeakerThan(oarg1));
        Assertions.assertFalse((boolean)marg1.isWeakerThan(marg0));
        Assertions.assertFalse((boolean)marg1.isWeakerThan(oarg0));
        Assertions.assertFalse((boolean)oarg1.isWeakerThan(marg0));
        Assertions.assertFalse((boolean)oarg1.isWeakerThan(oarg0));
        Assertions.assertFalse((boolean)oarg0.isWeakerThan(null));
    }

    @Test
    void testIsWeakerThanWrap() {
        FormalArg margD = new FormalArg("Arg0", Double.class, Necessity.MANDATORY);
        FormalArg oargD = new FormalArg("Arg0", Double.class, Necessity.OPTIONAL);
        FormalArg margd = new FormalArg("Arg0", Double.TYPE, Necessity.MANDATORY);
        FormalArg oargd = new FormalArg("Arg0", Double.TYPE, Necessity.OPTIONAL);
        Assertions.assertTrue((boolean)margD.isWeakerThan(margD));
        Assertions.assertFalse((boolean)margD.isWeakerThan(oargD));
        Assertions.assertTrue((boolean)margD.isWeakerThan(margd));
        Assertions.assertFalse((boolean)margD.isWeakerThan(oargd));
        Assertions.assertTrue((boolean)margd.isWeakerThan(margD));
        Assertions.assertFalse((boolean)margd.isWeakerThan(oargD));
        Assertions.assertTrue((boolean)margd.isWeakerThan(margd));
        Assertions.assertFalse((boolean)margd.isWeakerThan(oargd));
        Assertions.assertTrue((boolean)oargD.isWeakerThan(margD));
        Assertions.assertTrue((boolean)oargD.isWeakerThan(oargD));
        Assertions.assertTrue((boolean)oargD.isWeakerThan(margd));
        Assertions.assertTrue((boolean)oargD.isWeakerThan(oargd));
        Assertions.assertTrue((boolean)oargd.isWeakerThan(margD));
        Assertions.assertTrue((boolean)oargd.isWeakerThan(oargD));
        Assertions.assertTrue((boolean)oargd.isWeakerThan(margd));
        Assertions.assertTrue((boolean)oargd.isWeakerThan(oargd));
    }

    @Test
    void testMatchesName() {
        FormalArg farg0 = new FormalArg("Arg0", Object.class, Necessity.MANDATORY);
        Assertions.assertTrue((boolean)farg0.matchesName("Arg0"));
        Assertions.assertFalse((boolean)farg0.matchesName("arg0"));
    }

    @Test
    void testHasWeakerType() {
        FormalArg farg0 = new FormalArg("Arg0", Object.class, Necessity.MANDATORY);
        Assertions.assertTrue((boolean)farg0.hasWeakerType(Object.class));
        Assertions.assertTrue((boolean)farg0.hasWeakerType(String.class));
        Assertions.assertTrue((boolean)farg0.hasWeakerType(Float.class));
        Assertions.assertTrue((boolean)farg0.hasWeakerType(Float.TYPE));
        FormalArg farg1 = new FormalArg("Arg1", String.class, Necessity.MANDATORY);
        Assertions.assertFalse((boolean)farg1.hasWeakerType(Object.class));
        Assertions.assertTrue((boolean)farg1.hasWeakerType(String.class));
        FormalArg farg2 = new FormalArg("Arg2", Float.TYPE, Necessity.MANDATORY);
        Assertions.assertTrue((boolean)farg2.hasWeakerType(Float.TYPE));
        Assertions.assertTrue((boolean)farg2.hasWeakerType(Float.class));
    }

    @Test
    void testHasWeakerNecessity() {
        FormalArg farg0 = new FormalArg("Arg0", Object.class, Necessity.MANDATORY);
        Assertions.assertTrue((boolean)farg0.hasWeakerNecessity(Necessity.MANDATORY));
        Assertions.assertFalse((boolean)farg0.hasWeakerNecessity(Necessity.OPTIONAL));
        FormalArg farg1 = new FormalArg("Arg0", Object.class, Necessity.OPTIONAL);
        Assertions.assertTrue((boolean)farg1.hasWeakerNecessity(Necessity.MANDATORY));
        Assertions.assertTrue((boolean)farg1.hasWeakerNecessity(Necessity.OPTIONAL));
    }

    @Test
    void testEquals() {
        FormalArg farg0 = new FormalArg("Arg0", Object.class, Necessity.MANDATORY);
        FormalArg farg1 = new FormalArg("Arg0", Object.class, Necessity.MANDATORY);
        FormalArg farg2 = new FormalArg("Arg0", Object.class, Necessity.OPTIONAL);
        Assertions.assertTrue((boolean)farg0.equals((Object)farg0));
        Assertions.assertTrue((boolean)farg0.equals((Object)farg1));
        Assertions.assertFalse((boolean)farg0.equals((Object)farg2));
        Assertions.assertFalse((boolean)farg0.equals(null));
    }

    @Test
    void testBasic() {
        FormalArg farg0 = new FormalArg("Arg0", Object.class, Necessity.MANDATORY);
        LOGGER.debug("{} {}", (Object)farg0, (Object)farg0.hashCode());
        Assertions.assertTrue((boolean)true);
    }

    @Test
    void testMerge() {
        FormalArg optionalNumber = new FormalArg("number", Number.class, Necessity.OPTIONAL);
        FormalArg mandatoryNumber = new FormalArg("number", Number.class, Necessity.MANDATORY);
        FormalArg optionalInteger = new FormalArg("number", Integer.class, Necessity.OPTIONAL);
        FormalArg mandatoryInteger = new FormalArg("number", Integer.class, Necessity.MANDATORY);
        FormalArg mandatoryString = new FormalArg("number", String.class, Necessity.MANDATORY);
        FormalArg optionalFloat = new FormalArg("float", Float.class, Necessity.OPTIONAL);
        Assertions.assertEquals(null, (Object)FormalArg.merge(null, null, (Necessity)Necessity.MANDATORY));
        Assertions.assertEquals((Object)mandatoryNumber, (Object)FormalArg.merge((FormalArg)mandatoryNumber, null, (Necessity)Necessity.MANDATORY));
        Assertions.assertEquals((Object)mandatoryNumber, (Object)FormalArg.merge(null, (FormalArg)mandatoryNumber, (Necessity)Necessity.MANDATORY));
        Assertions.assertEquals((Object)mandatoryNumber, (Object)FormalArg.merge((FormalArg)mandatoryNumber, null, (Necessity)Necessity.OPTIONAL));
        Assertions.assertEquals((Object)mandatoryNumber, (Object)FormalArg.merge(null, (FormalArg)mandatoryNumber, (Necessity)Necessity.OPTIONAL));
        Assertions.assertEquals((Object)optionalNumber, (Object)FormalArg.merge((FormalArg)optionalNumber, null, (Necessity)Necessity.MANDATORY));
        Assertions.assertEquals((Object)optionalNumber, (Object)FormalArg.merge(null, (FormalArg)optionalNumber, (Necessity)Necessity.MANDATORY));
        Assertions.assertEquals((Object)optionalNumber, (Object)FormalArg.merge((FormalArg)optionalNumber, null, (Necessity)Necessity.OPTIONAL));
        Assertions.assertEquals((Object)optionalNumber, (Object)FormalArg.merge(null, (FormalArg)optionalNumber, (Necessity)Necessity.OPTIONAL));
        Assertions.assertEquals((Object)mandatoryNumber, (Object)FormalArg.merge((FormalArg)mandatoryNumber, (FormalArg)mandatoryNumber, (Necessity)Necessity.OPTIONAL));
        Assertions.assertEquals((Object)mandatoryNumber, (Object)FormalArg.merge((FormalArg)mandatoryNumber, (FormalArg)mandatoryNumber, (Necessity)Necessity.MANDATORY));
        Assertions.assertEquals((Object)optionalNumber, (Object)FormalArg.merge((FormalArg)optionalNumber, (FormalArg)optionalNumber, (Necessity)Necessity.OPTIONAL));
        Assertions.assertEquals((Object)optionalNumber, (Object)FormalArg.merge((FormalArg)optionalNumber, (FormalArg)optionalNumber, (Necessity)Necessity.MANDATORY));
        Assertions.assertEquals((Object)optionalNumber, (Object)FormalArg.merge((FormalArg)mandatoryNumber, (FormalArg)optionalNumber, (Necessity)Necessity.OPTIONAL));
        Assertions.assertEquals((Object)optionalNumber, (Object)FormalArg.merge((FormalArg)optionalNumber, (FormalArg)mandatoryNumber, (Necessity)Necessity.OPTIONAL));
        Assertions.assertEquals((Object)mandatoryNumber, (Object)FormalArg.merge((FormalArg)mandatoryNumber, (FormalArg)optionalNumber, (Necessity)Necessity.MANDATORY));
        Assertions.assertEquals((Object)mandatoryNumber, (Object)FormalArg.merge((FormalArg)optionalNumber, (FormalArg)mandatoryNumber, (Necessity)Necessity.MANDATORY));
        Assertions.assertEquals((Object)mandatoryInteger, (Object)FormalArg.merge((FormalArg)mandatoryNumber, (FormalArg)mandatoryInteger, (Necessity)Necessity.OPTIONAL));
        Assertions.assertEquals((Object)optionalInteger, (Object)FormalArg.merge((FormalArg)mandatoryNumber, (FormalArg)optionalInteger, (Necessity)Necessity.OPTIONAL));
        Assertions.assertEquals((Object)mandatoryInteger, (Object)FormalArg.merge((FormalArg)mandatoryNumber, (FormalArg)mandatoryInteger, (Necessity)Necessity.MANDATORY));
        Assertions.assertEquals((Object)mandatoryInteger, (Object)FormalArg.merge((FormalArg)mandatoryNumber, (FormalArg)optionalInteger, (Necessity)Necessity.MANDATORY));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FormalArg.merge((FormalArg)mandatoryNumber, (FormalArg)mandatoryString, (Necessity)Necessity.MANDATORY));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FormalArg.merge((FormalArg)optionalFloat, (FormalArg)optionalInteger, (Necessity)Necessity.MANDATORY));
    }
}

